{* modules/addons/powerdns_manager/templates/clientarea.tpl *}

<div class="panel panel-default">
    <div class="panel-body">
        {if count($zones) > 0}
            {if $nameservers && $show_nameservers}
                <div class="alert alert-info nameservers-box margin-bottom-20">
                    <h4><i class="fas fa-info-circle"></i> {$ADDONLANG.nameservers_title}</h4>
                    <p>{$ADDONLANG.nameservers_info}</p>
                    <ul class="list-unstyled">
                        {foreach from=$nameservers item=ns}
                            <li><i class="fas fa-check-circle"></i> <strong>{$ns}</strong></li>
                        {/foreach}
                    </ul>
                    <p class="margin-top-10 margin-bottom-0"><small>{$ADDONLANG.nameservers_note}</small></p>
                </div>
            {/if}
            
            <p class="text-muted"><i class="fas fa-info-circle"></i> {$ADDONLANG.select_zone}</p>
            
            <div class="table-container">
                <table class="table table-striped table-hover" id="dns-zones-table">
                    <thead>
                        <tr>
                            <th width="20%"><i class="fas fa-globe"></i> {$ADDONLANG.dns_zone}</th>
                            <th width="20%"><i class="fas fa-tag"></i> {$ADDONLANG.type}</th>
                            <th width="15%"><i class="fas fa-calendar"></i> {$ADDONLANG.created}</th>
                            <th width="12%" class="text-center"><i class="fas fa-server"></i> {$ADDONLANG.ns_status}</th>
                            <th width="13%" class="text-center"><i class="fas fa-shield-alt"></i> DNSSEC</th>
                            <th width="20%" class="text-center">{$ADDONLANG.actions}</th>
                        </tr>
                    </thead>
                    <tbody>
                        {* Group zones by zone_name and collect all types for each zone *}
                        {assign var="groupedZones" value=[]}
                        {foreach from=$zones item=zone}
                            {if !isset($groupedZones[$zone->zone_name])}
                                {assign var="groupedZones" value=$groupedZones|@array_merge:[$zone->zone_name => ['zone' => $zone, 'types' => []]]}
                            {/if}
                            {if $zone->domain_id}
                                {assign var="groupedZones" value=$groupedZones|@array_merge:[$zone->zone_name => ['zone' => $zone, 'types' => $groupedZones[$zone->zone_name].types|@array_merge:[['type' => 'domain', 'id' => $zone->domain_id]]]]}
                            {elseif $zone->service_id}
                                {assign var="groupedZones" value=$groupedZones|@array_merge:[$zone->zone_name => ['zone' => $zone, 'types' => $groupedZones[$zone->zone_name].types|@array_merge:[['type' => 'service', 'id' => $zone->service_id]]]]}
                            {else}
                                {assign var="groupedZones" value=$groupedZones|@array_merge:[$zone->zone_name => ['zone' => $zone, 'types' => $groupedZones[$zone->zone_name].types|@array_merge:[['type' => 'unknown', 'id' => null]]]]}
                            {/if}
                        {/foreach}
                        {foreach from=$groupedZones item=zoneData}
                            <tr data-domain="{$zoneData.zone->zone_name}">
                                <td>
                                    <strong>{$zoneData.zone->zone_name}</strong>
                                </td>
                                <td>
                                    {foreach from=$zoneData.types item=typeInfo}
                                        {if $typeInfo.type == 'domain'}
                                            <span class="label label-info">
                                                <i class="fas fa-globe"></i> {$ADDONLANG.domain}
                                            </span>
                                        {elseif $typeInfo.type == 'service'}
                                            <span class="label label-success">
                                                <i class="fas fa-server"></i> {$ADDONLANG.service}
                                            </span>
                                        {else}
                                            <span class="label label-default">
                                                <i class="fas fa-question-circle"></i> {$ADDONLANG.unknown}
                                            </span>
                                        {/if}
                                        {if !$typeInfo@last}&nbsp;{/if}
                                    {/foreach}
                                </td>
                                <td data-sort="{$zoneData.zone->created_at|date_format:'%Y-%m-%d %H:%M:%S'}">
                                    <span class="text-muted">
                                        <i class="far fa-clock"></i> {$zoneData.zone->created_at|date_format:"%d %b %Y"}
                                    </span>
                                </td>
                                <td class="text-center ns-status-cell" data-domain="{$zoneData.zone->zone_name}">
                                    <i class="fas fa-question-circle text-muted ns-check-button" data-toggle="tooltip" title="{$ADDONLANG.ns_status_click_to_check}" style="cursor: pointer;" onclick="checkSingleNameserver('{$zoneData.zone->zone_name}')"></i>
                                </td>
                                <td class="text-center dnssec-status-cell" data-domain="{$zoneData.zone->zone_name}">
                                    {if isset($zoneData.zone->dnssec_status)}
                                        {if $zoneData.zone->dnssec_status == 'enabled'}
                                            <span class="label label-success" data-toggle="tooltip" title="{$ADDONLANG.dnssec_management}">{$ADDONLANG.dnssec_enabled}</span>
                                        {elseif $zoneData.zone->dnssec_status == 'disabled'}
                                            <span class="label label-default" data-toggle="tooltip" title="{$ADDONLANG.dnssec_management}">{$ADDONLANG.dnssec_disabled}</span>
                                        {else}
                                            <span class="label label-warning" data-toggle="tooltip" title="Error checking DNSSEC status">Error</span>
                                        {/if}
                                    {else}
                                        <span class="label label-warning" data-toggle="tooltip" title="DNSSEC status unknown">Unknown</span>
                                    {/if}
                                </td>
                                <td class="text-center">
                                    <a href="index.php?m=powerdns_manager&action=viewzone&id={$zoneData.zone->id}" class="btn btn-primary btn-sm" data-toggle="tooltip" title="{$ADDONLANG.manage_records}" style="margin-right: 4px;">
                                        <i class="fas fa-cogs"></i>
                                    </a>
                                    <a href="index.php?m=powerdns_manager&action=viewzone&id={$zoneData.zone->id}&export_zone=1" class="btn btn-info btn-sm" data-toggle="tooltip" title="{$ADDONLANG.export_zone_tooltip}">
                                        <i class="fas fa-file-export"></i>
                                    </a>
                                </td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>
        {else}
            <div class="alert alert-info">
                <p><i class="fas fa-info-circle"></i> {$ADDONLANG.no_zones}</p>
            </div>
        {/if}
    </div>
</div>



<div id="ns-check-loading" class="alert alert-info" style="display: none;">
    <i class="fas fa-spinner fa-spin"></i> {$LANG.checking_nameservers}
</div>
<div id="ns-check-status" class="alert" style="display: none;"></div>
<div id="ns-check-results" style="display: none;">
    <div class="row">
        <div class="col-md-6">
            <h5>{$LANG.expected_nameservers}</h5>
            <ul id="expected-ns"></ul>
        </div>
        <div class="col-md-6">
            <h5>{$LANG.actual_nameservers} {if $settings.public_dns_server eq 'Cloudflare (1.1.1.1)'}<small>(Cloudflare 1.1.1.1)</small>{else}<small>(Google DNS 8.8.8.8)</small>{/if}</h5>
            <ul id="actual-ns"></ul>
        </div>
    </div>
</div>

<style type="text/css">
.label {
    display: inline;
    padding: .3em .6em;
    font-weight: 500;
    font-size: 11px;
    line-height: 1.2;
    color: #fff;
    text-align: center;
    white-space: nowrap;
    vertical-align: baseline;
    border-radius: .25em;
}
.label-info {
    background-color: #5bc0de;
}
.label-success {
    background-color: #5cb85c;
}
.label-default {
    background-color: #777;
}
.label-warning {
    background-color: #f0ad4e;
}
.nameservers-box h4 {
    margin-top: 0;
    margin-bottom: 10px;
}
.nameservers-box ul {
    margin-bottom: 10px;
}
.nameservers-box ul li {
    margin-bottom: 5px;
}
.margin-top-10 {
    margin-top: 10px;
}
.margin-bottom-0 {
    margin-bottom: 0;
}
.margin-bottom-20 {
    margin-bottom: 20px;
}
.dataTables_filter input.form-control {
    border: 1.5px solid #0e83c8;
    background: #fff;
    color: #222;
    font-weight: 500;
    box-shadow: 0 2px 6px rgba(14,131,200,0.07);
    transition: border-color 0.2s;
}
.dataTables_filter input.form-control:focus {
    border-color: #095a8e;
    background: #f5faff;
    color: #111;
}
.dataTables_info { display: none !important; }

/* Add spacing for DataTables controls */
.dataTables_wrapper .dataTables_length,
.dataTables_wrapper .dataTables_filter {
    margin-top: 15px;
    margin-bottom: 15px;
}

.dataTables_wrapper .dataTables_length {
    margin-left: 15px;
}

.dataTables_wrapper .dataTables_filter {
    margin-right: 15px;
}

/* Add spacing for pagination controls */
.dataTables_wrapper .dataTables_paginate {
    margin-top: 8px !important;
    margin-bottom: 8px !important;
    margin-right: 8px !important;
    padding-right: 8px !important;
}

/* More specific targeting for pagination */
#dns-zones-table_paginate {
    margin-top: 8px !important;
    margin-bottom: 8px !important;
    margin-right: 8px !important;
    padding-right: 8px !important;
}

/* Target the pagination ul directly */
.dataTables_paginate .pagination {
    margin-right: 8px !important;
    margin-bottom: 8px !important;
}

/* NS Status column styling */
.ns-status-cell {
    font-size: 16px;
}

.ns-status-cell i.text-success {
    color: #28a745 !important;
}

.ns-status-cell i.text-warning {
    color: #ffc107 !important;
}

.ns-status-cell i.text-danger {
    color: #dc3545 !important;
}

.ns-status-cell i.text-muted {
    color: #6c757d !important;
}

/* Tooltip styling for multiline content */
.tooltip-inner {
    white-space: pre-line;
    text-align: left;
    max-width: 300px;
}

/* Make "Show ... records" text smaller */
.dataTables_wrapper .dataTables_length {
    font-size: 12px;
}

.dataTables_wrapper .dataTables_length select {
    font-size: 12px;
}

/* Reduce font size for table content for better data density */
#dns-zones-table {
    font-size: 13px;
}

#dns-zones-table td {
    font-size: 13px;
    line-height: 1.3;
    padding: 8px 12px;
}

#dns-zones-table th {
    font-size: 14px;
    font-weight: 600;
}
</style>

<script type="text/javascript">
jQuery(document).ready(function($) {
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
    
    // Initialize DataTables if available
    if ($.fn.DataTable) {
        $('#dns-zones-table').DataTable({
            "pageLength": 10,
            "order": [[0, "asc"]],
            "stateSave": true,
            "responsive": true,
            "autoWidth": false,
            "language": {
                "search": "",
                "searchPlaceholder": "{$ADDONLANG.search_zones}",
                "emptyTable": "{$ADDONLANG.no_dns_zones}",
                "zeroRecords": "{$ADDONLANG.no_matching_zones}",
                "lengthMenu": "{$ADDONLANG.show_records}"
            },
            "dom": '<"row"<"col-sm-6"l><"col-sm-6"f>>rt<"row"<"col-sm-6"i><"col-sm-6"p>>',
            "fnDrawCallback": function() {
                $('.dataTables_filter input').addClass('form-control');
                $('.dataTables_length select').addClass('form-control');
                
                // Re-initialize tooltips for any new elements
                $('[data-toggle="tooltip"]').tooltip();
            }
        });
    }
    
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
});

// Simple cache to avoid re-checking the same domain
var nsCheckCache = {};

// Public DNS server setting from module configuration
{if isset($settings.public_dns_server)}
window.publicDnsServer = '{$settings.public_dns_server}';
{else}
window.publicDnsServer = '8.8.8.8'; // Default to Google DNS
{/if}

function checkSingleNameserver(domain) {
    var statusCell = $('.ns-status-cell[data-domain="' + domain + '"]');
    var currentIcon = statusCell.find('i');
    
    // Check if this is a re-check (not a question mark = already checked before)
    var isRecheck = !currentIcon.hasClass('fa-question-circle');
    
    // For re-checks, skip cache to get fresh data
    if (!isRecheck && nsCheckCache[domain]) {
        updateNameserverStatus(domain, statusCell, nsCheckCache[domain]);
        return;
    }
    
    // Show loading state
    safeDestroyTooltips(statusCell.find('[data-toggle="tooltip"]'));
    statusCell.html('<i class="fas fa-spinner fa-spin text-primary" data-toggle="tooltip" title="' + (isRecheck ? '{$ADDONLANG.ns_status_rechecking}' : '{$ADDONLANG.ns_status_checking}') + '"></i>');
    statusCell.find('[data-toggle="tooltip"]').tooltip();
    
    // Prepare request data with public DNS server setting
    var requestData = {
        m: 'powerdns_manager',
        action: 'check_nameservers',
        domain: domain,
        ajax: 1
    };
    
    // Add public DNS server setting if available
    if (typeof window.publicDnsServer !== 'undefined') {
        requestData.public_dns_server = window.publicDnsServer;
    }
    
    // Make the request
    $.ajax({
        url: 'index.php',
        data: requestData,
        method: 'GET',
        timeout: 15000, // 15 second timeout
        success: function(response) {
            // Cache the result (will override previous cache for re-checks)
            nsCheckCache[domain] = response;
            updateNameserverStatus(domain, statusCell, response);
        },
        error: function(xhr, status, error) {
            updateNameserverStatus(domain, statusCell, null, 'Failed to check nameservers: ' + (status === 'timeout' ? 'Request timed out' : 'Network error'));
        }
    });
}

// Safe tooltip destruction for different Bootstrap versions
function safeDestroyTooltips(elements) {
    elements.each(function() {
        var $this = $(this);
        
        // Try different methods to clean up tooltips
        try {
            // Bootstrap 4/5 method
            if ($this.tooltip && typeof $this.tooltip === 'function') {
                if ($this.data('bs.tooltip')) {
                    $this.tooltip('dispose');
                } else if ($this.data('tooltip')) {
                    $this.tooltip('destroy');
                }
            }
        } catch (e) {
            // Ignore errors, try alternative cleanup
        }
        
        // Manual cleanup - remove tooltip-related attributes and data
        $this.removeAttr('data-original-title')
             .removeAttr('title')
             .removeData('bs.tooltip')
             .removeData('tooltip');
        
        // Remove any tooltip elements that might be left in DOM
        $('.tooltip').remove();
    });
}

function updateNameserverStatus(domain, statusCell, response, errorMessage) {
    // Safely destroy existing tooltips
    safeDestroyTooltips(statusCell.find('[data-toggle="tooltip"]'));
    
    try {
        if (errorMessage) {
            // Handle error case - make it clickable to retry
            statusCell.html('<i class="fas fa-times-circle text-danger ns-check-button" data-toggle="tooltip" title="' + errorMessage + ' ({$ADDONLANG.ns_status_click_to_check})" style="cursor: pointer;" onclick="checkSingleNameserver(\'' + domain + '\')"></i>');
        } else if (response && response.status === 'success') {
            if (response.data.matches) {
                // Nameservers match - show green checkmark (still clickable to re-check)
                statusCell.html('<i class="fas fa-check-circle text-success ns-check-button" data-toggle="tooltip" title="{$ADDONLANG.ns_status_correct} ({$ADDONLANG.ns_status_click_to_check})" style="cursor: pointer;" onclick="checkSingleNameserver(\'' + domain + '\')"></i>');
            } else {
                // Nameservers don't match - show warning (still clickable to re-check)
                var expectedNs = response.data.expected ? response.data.expected.join(', ') : 'Unknown';
                var actualNs = response.data.actual ? response.data.actual.join(', ') : 'Unknown';
                var tooltip = '{$ADDONLANG.ns_expected}: ' + expectedNs + '\n{$ADDONLANG.ns_actual}: ' + actualNs + '\n({$ADDONLANG.ns_status_click_to_check})';
                statusCell.html('<i class="fas fa-exclamation-triangle text-warning ns-check-button" data-toggle="tooltip" title="' + tooltip + '" style="cursor: pointer;" onclick="checkSingleNameserver(\'' + domain + '\')"></i>');
            }
        } else {
            // Server error - make it clickable to retry
            var message = (response && response.message) ? response.message : '{$ADDONLANG.ns_status_error}';
            statusCell.html('<i class="fas fa-times-circle text-danger ns-check-button" data-toggle="tooltip" title="' + message + ' ({$ADDONLANG.ns_status_click_to_check})" style="cursor: pointer;" onclick="checkSingleNameserver(\'' + domain + '\')"></i>');
        }
    } catch (e) {
        // Parse error - make it clickable to retry
        statusCell.html('<i class="fas fa-times-circle text-danger ns-check-button" data-toggle="tooltip" title="{$ADDONLANG.ns_status_error} ({$ADDONLANG.ns_status_click_to_check})" style="cursor: pointer;" onclick="checkSingleNameserver(\'' + domain + '\')"></i>');
    }
    
    // Initialize fresh tooltip
    setTimeout(function() {
        statusCell.find('[data-toggle="tooltip"]').tooltip();
    }, 100);
}


</script>
