/*
 * Decompiled with CFR 0.152.
 */
package live.thought.thought4j;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import live.thought.thought4j.GenericRpcException;
import live.thought.thought4j.ThoughtClientInterface;
import live.thought.thought4j.ThoughtRPCException;
import live.thought.thought4j.util.Base64Coder;
import live.thought.thought4j.util.CoinUtil;
import live.thought.thought4j.util.JSON;
import live.thought.thought4j.util.ListMapWrapper;
import live.thought.thought4j.util.MapWrapper;

public class ThoughtRPCClient
implements ThoughtClientInterface {
    private static final Logger logger;
    public final URL rpcURL;
    private URL noAuthURL;
    private String authStr;
    public static final URL DEFAULT_JSONRPC_URL;
    public static final URL DEFAULT_JSONRPC_TESTNET_URL;
    public static final URL DEFAULT_JSONRPC_REGTEST_URL;
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_USER = "user";
    public static final String DEFAULT_PASSWORD = "pass";
    public static final int DEFAULT_PORT = 10617;
    public static final int DEFAULT_TEST_PORT = 11617;
    public static final int DEFAULT_REGTEST_PORT = 12617;
    private HostnameVerifier hostnameVerifier = null;
    private SSLSocketFactory sslSocketFactory = null;
    public static final Charset QUERY_CHARSET;
    static Map<String, Collection<String>> addrParam;

    public ThoughtRPCClient(String rpcUrl) throws MalformedURLException {
        this(new URL(rpcUrl));
    }

    public ThoughtRPCClient(URL rpc) {
        this.rpcURL = rpc;
        try {
            this.noAuthURL = new URI(rpc.getProtocol(), null, rpc.getHost(), rpc.getPort(), rpc.getPath(), rpc.getQuery(), null).toURL();
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new IllegalArgumentException(rpc.toString(), ex);
        }
        this.authStr = rpc.getUserInfo() == null ? null : String.valueOf(Base64Coder.encode(rpc.getUserInfo().getBytes(Charset.forName("ISO8859-1"))));
    }

    public ThoughtRPCClient(boolean testNet) {
        this(testNet ? DEFAULT_JSONRPC_TESTNET_URL : DEFAULT_JSONRPC_URL);
    }

    public ThoughtRPCClient() {
        this(DEFAULT_JSONRPC_TESTNET_URL);
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public byte[] prepareRequest(final String method, final Object ... params) {
        return JSON.stringify(new LinkedHashMap<String, Object>(){
            private static final long serialVersionUID = 1L;
            {
                this.put("method", method);
                this.put("params", params);
                this.put("id", "1");
            }
        }).getBytes(QUERY_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] loadStream(InputStream in, boolean close) throws IOException {
        ByteArrayOutputStream o;
        block8: {
            o = new ByteArrayOutputStream();
            try {
                int nr;
                if (null == in) {
                    o.write("Null".getBytes());
                    break block8;
                }
                byte[] buffer = new byte[1024];
                while ((nr = in.read(buffer)) != -1) {
                    if (nr == 0) {
                        throw new IOException("Read timed out");
                    }
                    o.write(buffer, 0, nr);
                }
            }
            finally {
                if (close && null != in) {
                    in.close();
                }
            }
        }
        return o.toByteArray();
    }

    public Object loadResponse(InputStream in, Object expectedID, boolean close) throws IOException, GenericRpcException {
        String r = new String(ThoughtRPCClient.loadStream(in, close), QUERY_CHARSET);
        logger.log(Level.FINE, "Thought JSON-RPC response:\n{0}", r);
        try {
            Map response = (Map)JSON.parse(r);
            if (!expectedID.equals(response.get("id"))) {
                throw new ThoughtRPCException("Wrong response ID (expected: " + String.valueOf(expectedID) + ", response: " + response.get("id") + ")");
            }
            if (response.get("error") != null) {
                throw new GenericRpcException(JSON.stringify(response.get("error")));
            }
            return response.get("result");
        }
        catch (ClassCastException ex) {
            throw new ThoughtRPCException("Invalid server response format (data: \"" + r + "\")");
        }
    }

    public Object query(String method, Object ... o) throws GenericRpcException {
        try {
            HttpURLConnection conn = (HttpURLConnection)this.noAuthURL.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            if (conn instanceof HttpsURLConnection) {
                if (this.hostnameVerifier != null) {
                    ((HttpsURLConnection)conn).setHostnameVerifier(this.hostnameVerifier);
                }
                if (this.sslSocketFactory != null) {
                    ((HttpsURLConnection)conn).setSSLSocketFactory(this.sslSocketFactory);
                }
            }
            conn.setRequestProperty("Authorization", "Basic " + this.authStr);
            byte[] r = this.prepareRequest(method, o);
            logger.log(Level.FINE, "Thought JSON-RPC request:\n{0}", new String(r, QUERY_CHARSET));
            conn.getOutputStream().write(r);
            conn.getOutputStream().close();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                throw new ThoughtRPCException(method, Arrays.deepToString(o), responseCode, conn.getResponseMessage(), new String(ThoughtRPCClient.loadStream(conn.getErrorStream(), true)));
            }
            return this.loadResponse(conn.getInputStream(), "1", true);
        }
        catch (IOException ex) {
            throw new ThoughtRPCException(method, Arrays.deepToString(o), ex);
        }
    }

    public String queryJson(String method, Object ... o) throws GenericRpcException {
        try {
            HttpURLConnection conn = (HttpURLConnection)this.noAuthURL.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            if (conn instanceof HttpsURLConnection) {
                if (this.hostnameVerifier != null) {
                    ((HttpsURLConnection)conn).setHostnameVerifier(this.hostnameVerifier);
                }
                if (this.sslSocketFactory != null) {
                    ((HttpsURLConnection)conn).setSSLSocketFactory(this.sslSocketFactory);
                }
            }
            conn.setRequestProperty("Authorization", "Basic " + this.authStr);
            byte[] r = this.prepareRequest(method, o);
            logger.log(Level.FINE, "Thought JSON-RPC request:\n{0}", new String(r, QUERY_CHARSET));
            conn.getOutputStream().write(r);
            conn.getOutputStream().close();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                throw new ThoughtRPCException(method, Arrays.deepToString(o), responseCode, conn.getResponseMessage(), new String(ThoughtRPCClient.loadStream(conn.getErrorStream(), true)));
            }
            return new String(ThoughtRPCClient.loadStream(conn.getInputStream(), true));
        }
        catch (IOException ex) {
            throw new ThoughtRPCException(method, Arrays.deepToString(o), ex);
        }
    }

    @Override
    public String createRawTransaction(List<ThoughtClientInterface.TxInput> inputs, List<ThoughtClientInterface.TxOutput> outputs) throws GenericRpcException {
        ArrayList<2> pInputs = new ArrayList<2>();
        for (final ThoughtClientInterface.TxInput txInput : inputs) {
            pInputs.add(new LinkedHashMap<String, Object>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("txid", txInput.txid());
                    this.put("vout", txInput.vout());
                }
            });
        }
        LinkedHashMap<String, Double> pOutputs = new LinkedHashMap<String, Double>();
        for (ThoughtClientInterface.TxOutput txOutput : outputs) {
            Double oldValue = pOutputs.put(txOutput.address(), txOutput.amount());
            if (oldValue == null) continue;
            pOutputs.put(txOutput.address(), CoinUtil.normalizeAmount(oldValue + txOutput.amount()));
        }
        return (String)this.query("createrawtransaction", pInputs, pOutputs);
    }

    @Override
    public ThoughtClientInterface.FundedRawTransaction fundRawTransaction(String hexstring, ThoughtClientInterface.FundRawTransactionOptions options) throws GenericRpcException {
        Map result = null;
        if (null != options) {
            LinkedHashMap<String, Object> optionMap = new LinkedHashMap<String, Object>();
            if (null != options.getChangeAddress()) {
                optionMap.put("changeAddress", options.getChangeAddress());
            }
            if (null != options.getChangePosition()) {
                optionMap.put("changePosition", options.getChangePosition());
            }
            if (null != options.getIncludeWatching()) {
                optionMap.put("includeWatching", options.getIncludeWatching());
            }
            if (null != options.getLockUnspents()) {
                optionMap.put("lockUnspents", options.getLockUnspents());
            }
            if (null != options.getReserveChangeKey()) {
                optionMap.put("reserveChangeKey", options.getReserveChangeKey());
            }
            if (null != options.getFeeRate()) {
                optionMap.put("feeRate", options.getFeeRate());
            }
            if (null != options.getSubtractFeeFromOutputs()) {
                optionMap.put("subtractFeeFromOutputs", options.getSubtractFeeFromOutputs());
            }
            result = (Map)this.query("fundrawtransaction", hexstring, optionMap);
        } else {
            result = (Map)this.query("fundrawtransaction", hexstring);
        }
        return new FundedRawTransactionImpl(result);
    }

    @Override
    public String dumpPrivKey(String address) throws GenericRpcException {
        return (String)this.query("dumpprivkey", address);
    }

    @Override
    public String getAccount(String address) throws GenericRpcException {
        return (String)this.query("getaccount", address);
    }

    @Override
    public String getAccountAddress(String account) throws GenericRpcException {
        return (String)this.query("getaccountaddress", account);
    }

    @Override
    public List<String> getAddressesByAccount(String account) throws GenericRpcException {
        return (List)this.query("getaddressesbyaccount", account);
    }

    @Override
    public double getBalance() throws GenericRpcException {
        return ((Number)this.query("getbalance", new Object[0])).doubleValue();
    }

    @Override
    public double getBalance(String account) throws GenericRpcException {
        return ((Number)this.query("getbalance", account)).doubleValue();
    }

    @Override
    public double getBalance(String account, int minConf) throws GenericRpcException {
        return ((Number)this.query("getbalance", account, minConf)).doubleValue();
    }

    @Override
    public Map<String, Double> listAddressBalances(double minBalance) throws GenericRpcException {
        return (Map)this.query("listaddressbalances", minBalance);
    }

    @Override
    public double getAddressBalance(Set<String> addresses) throws GenericRpcException {
        addrParam.put("addresses", addresses);
        Map retval = (Map)this.query("getaddressbalance", addrParam);
        double notions = ((Number)retval.get("balance")).doubleValue();
        return notions / 1.0E8;
    }

    @Override
    public ThoughtClientInterface.SmartFeeResult getEstimateSmartFee(int blocks) {
        return new SmartFeeResultMapWrapper((Map)this.query("estimatesmartfee", blocks));
    }

    @Override
    public ThoughtClientInterface.Block getBlock(int height) throws GenericRpcException {
        String hash = (String)this.query("getblockhash", height);
        return this.getBlock(hash);
    }

    @Override
    public ThoughtClientInterface.Block getBlock(String blockHash) throws GenericRpcException {
        return new BlockMapWrapper((Map)this.query("getblock", blockHash));
    }

    @Override
    public String getRawBlock(String blockHash) throws GenericRpcException {
        return (String)this.query("getblock", blockHash, false);
    }

    @Override
    public String getBlockHash(int height) throws GenericRpcException {
        return (String)this.query("getblockhash", height);
    }

    @Override
    public ThoughtClientInterface.BlockChainInfo getBlockChainInfo() throws GenericRpcException {
        return new BlockChainInfoMapWrapper((Map)this.query("getblockchaininfo", new Object[0]));
    }

    @Override
    public int getBlockCount() throws GenericRpcException {
        return ((Number)this.query("getblockcount", new Object[0])).intValue();
    }

    @Override
    public ThoughtClientInterface.Info getInfo() throws GenericRpcException {
        return new InfoWrapper((Map)this.query("getinfo", new Object[0]));
    }

    @Override
    public ThoughtClientInterface.TxOutSetInfo getTxOutSetInfo() throws GenericRpcException {
        return new TxOutSetInfoWrapper((Map)this.query("gettxoutsetinfo", new Object[0]));
    }

    @Override
    public ThoughtClientInterface.NetworkInfo getNetworkInfo() throws GenericRpcException {
        return new NetworkInfoWrapper((Map)this.query("getnetworkinfo", new Object[0]));
    }

    @Override
    public ThoughtClientInterface.MiningInfo getMiningInfo() throws GenericRpcException {
        return new MiningInfoWrapper((Map)this.query("getmininginfo", new Object[0]));
    }

    @Override
    public ThoughtClientInterface.BlockTemplate getBlockTemplate() throws GenericRpcException {
        return new BlockTemplateWrapper((Map)this.query("getblocktemplate", new Object[0]));
    }

    @Override
    public ThoughtClientInterface.BlockTemplate getBlockTemplate(String longpollid) throws GenericRpcException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("longpollid", longpollid);
        return new BlockTemplateWrapper((Map)this.query("getblocktemplate", params));
    }

    @Override
    public List<ThoughtClientInterface.NodeInfo> getAddedNodeInfo(boolean dummy, String node) throws GenericRpcException {
        List list = (List)this.query("getaddednodeinfo", dummy, node);
        LinkedList<ThoughtClientInterface.NodeInfo> nodeInfoList = new LinkedList<ThoughtClientInterface.NodeInfo>();
        for (Map m : list) {
            NodeInfoWrapper niw = new NodeInfoWrapper(m);
            nodeInfoList.add(niw);
        }
        return nodeInfoList;
    }

    @Override
    public ThoughtClientInterface.MultiSig createMultiSig(int nRequired, List<String> keys) throws GenericRpcException {
        return new MultiSigWrapper((Map)this.query("createmultisig", nRequired, keys));
    }

    @Override
    public ThoughtClientInterface.WalletInfo getWalletInfo() {
        return new WalletInfoWrapper((Map)this.query("getwalletinfo", new Object[0]));
    }

    @Override
    public String getNewAddress() throws GenericRpcException {
        return (String)this.query("getnewaddress", new Object[0]);
    }

    @Override
    public String getNewAddress(String account) throws GenericRpcException {
        return (String)this.query("getnewaddress", account);
    }

    @Override
    public List<String> getRawMemPool() throws GenericRpcException {
        return (List)this.query("getrawmempool", new Object[0]);
    }

    @Override
    public String getBestBlockHash() throws GenericRpcException {
        return (String)this.query("getbestblockhash", new Object[0]);
    }

    @Override
    public String getRawTransactionHex(String txId) throws GenericRpcException {
        return (String)this.query("getrawtransaction", txId);
    }

    @Override
    public ThoughtClientInterface.RawTransaction getRawTransaction(String txId) throws GenericRpcException {
        return new RawTransactionImpl((Map)this.query("getrawtransaction", txId, 1));
    }

    @Override
    public double getReceivedByAddress(String address) throws GenericRpcException {
        return ((Number)this.query("getreceivedbyaddress", address)).doubleValue();
    }

    @Override
    public double getReceivedByAddress(String address, int minConf) throws GenericRpcException {
        return ((Number)this.query("getreceivedbyaddress", address, minConf)).doubleValue();
    }

    @Override
    public void importPrivKey(String thoughtPrivKey) throws GenericRpcException {
        this.query("importprivkey", thoughtPrivKey);
    }

    @Override
    public void importPrivKey(String thoughtPrivKey, String label) throws GenericRpcException {
        this.query("importprivkey", thoughtPrivKey, label);
    }

    @Override
    public void importPrivKey(String thoughtPrivKey, String label, boolean rescan) throws GenericRpcException {
        this.query("importprivkey", thoughtPrivKey, label, rescan);
    }

    @Override
    public Object importAddress(String address, String label, boolean rescan) throws GenericRpcException {
        this.query("importaddress", address, label, rescan);
        return null;
    }

    @Override
    public Map<String, Number> listAccounts() throws GenericRpcException {
        return (Map)this.query("listaccounts", new Object[0]);
    }

    @Override
    public Map<String, Number> listAccounts(int minConf) throws GenericRpcException {
        return (Map)this.query("listaccounts", minConf);
    }

    @Override
    public List<ThoughtClientInterface.ReceivedAddress> listReceivedByAddress() throws GenericRpcException {
        return new ReceivedAddressListWrapper((List)this.query("listreceivedbyaddress", new Object[0]));
    }

    @Override
    public List<ThoughtClientInterface.ReceivedAddress> listReceivedByAddress(int minConf) throws GenericRpcException {
        return new ReceivedAddressListWrapper((List)this.query("listreceivedbyaddress", minConf));
    }

    @Override
    public List<ThoughtClientInterface.ReceivedAddress> listReceivedByAddress(int minConf, boolean includeEmpty) throws GenericRpcException {
        return new ReceivedAddressListWrapper((List)this.query("listreceivedbyaddress", minConf, includeEmpty));
    }

    @Override
    public ThoughtClientInterface.TransactionsSinceBlock listSinceBlock() throws GenericRpcException {
        return new TransactionsSinceBlockImpl((Map)this.query("listsinceblock", new Object[0]));
    }

    @Override
    public ThoughtClientInterface.TransactionsSinceBlock listSinceBlock(String blockHash) throws GenericRpcException {
        return new TransactionsSinceBlockImpl((Map)this.query("listsinceblock", blockHash));
    }

    @Override
    public ThoughtClientInterface.TransactionsSinceBlock listSinceBlock(String blockHash, int targetConfirmations) throws GenericRpcException {
        return new TransactionsSinceBlockImpl((Map)this.query("listsinceblock", blockHash, targetConfirmations));
    }

    @Override
    public List<ThoughtClientInterface.Transaction> listTransactions() throws GenericRpcException {
        return new TransactionListMapWrapper((List)this.query("listtransactions", new Object[0]));
    }

    @Override
    public List<ThoughtClientInterface.Transaction> listTransactions(String account) throws GenericRpcException {
        return new TransactionListMapWrapper((List)this.query("listtransactions", account));
    }

    @Override
    public List<ThoughtClientInterface.Transaction> listTransactions(String account, int count) throws GenericRpcException {
        return new TransactionListMapWrapper((List)this.query("listtransactions", account, count));
    }

    @Override
    public List<ThoughtClientInterface.Transaction> listTransactions(String account, int count, int skip) throws GenericRpcException {
        return new TransactionListMapWrapper((List)this.query("listtransactions", account, count, skip));
    }

    @Override
    public List<ThoughtClientInterface.Unspent> listUnspent() throws GenericRpcException {
        return new UnspentListWrapper((List)this.query("listunspent", new Object[0]));
    }

    @Override
    public List<ThoughtClientInterface.Unspent> listUnspent(int minConf) throws GenericRpcException {
        return new UnspentListWrapper((List)this.query("listunspent", minConf));
    }

    @Override
    public List<ThoughtClientInterface.Unspent> listUnspent(int minConf, int maxConf) throws GenericRpcException {
        return new UnspentListWrapper((List)this.query("listunspent", minConf, maxConf));
    }

    @Override
    public List<ThoughtClientInterface.Unspent> listUnspent(int minConf, int maxConf, String ... addresses) throws GenericRpcException {
        return new UnspentListWrapper((List)this.query("listunspent", minConf, maxConf, addresses));
    }

    @Override
    public String listUnspentJson(int minConf, int maxConf, String ... addresses) throws GenericRpcException {
        return this.queryJson("listunspent", minConf, maxConf, addresses);
    }

    @Override
    public boolean move(String fromAccount, String toAddress, double amount) throws GenericRpcException {
        return (Boolean)this.query("move", fromAccount, toAddress, amount);
    }

    @Override
    public boolean move(String fromAccount, String toAddress, double amount, String comment) throws GenericRpcException {
        return (Boolean)this.query("move", fromAccount, toAddress, amount, 0, comment);
    }

    @Override
    public boolean move(String fromAccount, String toAddress, double amount, int minConf) throws GenericRpcException {
        return (Boolean)this.query("move", fromAccount, toAddress, amount, minConf);
    }

    @Override
    public boolean move(String fromAccount, String toAddress, double amount, int minConf, String comment) throws GenericRpcException {
        return (Boolean)this.query("move", fromAccount, toAddress, amount, minConf, comment);
    }

    @Override
    public String sendFrom(String fromAccount, String toAddress, double amount) throws GenericRpcException {
        return (String)this.query("sendfrom", fromAccount, toAddress, amount);
    }

    @Override
    public String sendFrom(String fromAccount, String toAddress, double amount, int minConf) throws GenericRpcException {
        return (String)this.query("sendfrom", fromAccount, toAddress, amount, minConf);
    }

    @Override
    public String sendFrom(String fromAccount, String toAddress, double amount, int minConf, boolean addlocked, String comment) throws GenericRpcException {
        return (String)this.query("sendfrom", fromAccount, toAddress, amount, minConf, addlocked, comment);
    }

    @Override
    public String sendFrom(String fromAccount, String toAddress, double amount, int minConf, boolean addlocked, String comment, String commentTo) throws GenericRpcException {
        return (String)this.query("sendfrom", fromAccount, toAddress, amount, minConf, addlocked, comment, commentTo);
    }

    @Override
    public String sendRawTransaction(String hex) throws GenericRpcException {
        return (String)this.query("sendrawtransaction", hex);
    }

    @Override
    public String sendToAddress(String toAddress, double amount) throws GenericRpcException {
        return (String)this.query("sendtoaddress", toAddress, amount);
    }

    @Override
    public String sendToAddress(String toAddress, double amount, String comment) throws GenericRpcException {
        return (String)this.query("sendtoaddress", toAddress, amount, comment);
    }

    @Override
    public String sendToAddress(String toAddress, double amount, String comment, String commentTo) throws GenericRpcException {
        return (String)this.query("sendtoaddress", toAddress, amount, comment, commentTo);
    }

    @Override
    public String sendToAddress(String toAddress, double amount, String comment, String commentTo, boolean subtractfeefromamount, boolean use_is, boolean use_ps) throws GenericRpcException {
        return (String)this.query("sendtoaddress", toAddress, amount, comment, commentTo, subtractfeefromamount, use_is, use_ps);
    }

    public String signRawTransaction(String hex) throws GenericRpcException {
        return this.signRawTransaction(hex, null, null, "ALL");
    }

    @Override
    public String signRawTransaction(String hex, List<? extends ThoughtClientInterface.TxInput> inputs, List<String> privateKeys) throws GenericRpcException {
        return this.signRawTransaction(hex, inputs, privateKeys, "ALL");
    }

    public String signRawTransaction(String hex, List<? extends ThoughtClientInterface.TxInput> inputs, List<String> privateKeys, String sigHashType) {
        Map result;
        ArrayList<3> pInputs = null;
        if (inputs != null) {
            pInputs = new ArrayList<3>();
            for (final ThoughtClientInterface.TxInput txInput : inputs) {
                pInputs.add(new LinkedHashMap<String, Object>(){
                    private static final long serialVersionUID = 1L;
                    {
                        this.put("txid", txInput.txid());
                        this.put("vout", txInput.vout());
                        this.put("scriptPubKey", txInput.scriptPubKey());
                        if (txInput instanceof ThoughtClientInterface.ExtendedTxInput) {
                            ThoughtClientInterface.ExtendedTxInput extin = (ThoughtClientInterface.ExtendedTxInput)txInput;
                            this.put("redeemScript", extin.redeemScript());
                            this.put("amount", extin.amount());
                        }
                    }
                });
            }
        }
        if (((Boolean)(result = (Map)this.query("signrawtransaction", hex, pInputs, privateKeys, sigHashType)).get("complete")).booleanValue()) {
            return (String)result.get("hex");
        }
        throw new GenericRpcException("Incomplete");
    }

    public ThoughtClientInterface.RawTransaction decodeRawTransaction(String hex) throws GenericRpcException {
        Map result = (Map)this.query("decoderawtransaction", hex);
        RawTransactionImpl rawTransaction = new RawTransactionImpl(result);
        return rawTransaction.vOut().get(0).transaction();
    }

    @Override
    public ThoughtClientInterface.AddressValidationResult validateAddress(String address) throws GenericRpcException {
        final Map validationResult = (Map)this.query("validateaddress", address);
        return new ThoughtClientInterface.AddressValidationResult(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isValid() {
                return (Boolean)validationResult.get("isvalid");
            }

            @Override
            public String address() {
                return (String)validationResult.get("address");
            }

            @Override
            public boolean isMine() {
                return (Boolean)validationResult.get("ismine");
            }

            @Override
            public boolean isScript() {
                return (Boolean)validationResult.get("isscript");
            }

            @Override
            public String pubKey() {
                return (String)validationResult.get("pubkey");
            }

            @Override
            public boolean isCompressed() {
                return (Boolean)validationResult.get("iscompressed");
            }

            @Override
            public String account() {
                return (String)validationResult.get("account");
            }

            public String toString() {
                return validationResult.toString();
            }
        };
    }

    @Override
    public void setGenerate(boolean b) throws ThoughtRPCException {
        this.query("setgenerate", b);
    }

    @Override
    public List<String> generate(int numBlocks) throws ThoughtRPCException {
        return (List)this.query("generate", numBlocks);
    }

    @Override
    public List<String> generate(int numBlocks, long maxTries) throws ThoughtRPCException {
        return (List)this.query("generate", numBlocks, maxTries);
    }

    @Override
    public List<String> generateToAddress(int numBlocks, String address) throws ThoughtRPCException {
        return (List)this.query("generatetoaddress", numBlocks, address);
    }

    @Override
    public double getEstimateFee(int nBlocks) throws GenericRpcException {
        return ((Number)this.query("estimatefee", nBlocks)).doubleValue();
    }

    @Override
    public double getEstimatePriority(int nBlocks) throws GenericRpcException {
        return ((Number)this.query("estimatepriority", nBlocks)).doubleValue();
    }

    @Override
    public void invalidateBlock(String hash) throws GenericRpcException {
        this.query("invalidateblock", hash);
    }

    @Override
    public void reconsiderBlock(String hash) throws GenericRpcException {
        this.query("reconsiderblock", hash);
    }

    @Override
    public List<ThoughtClientInterface.PeerInfoResult> getPeerInfo() throws GenericRpcException {
        final List l = (List)this.query("getpeerinfo", new Object[0]);
        return new AbstractList<ThoughtClientInterface.PeerInfoResult>(){

            @Override
            public ThoughtClientInterface.PeerInfoResult get(int index) {
                return new PeerInfoWrapper((Map)l.get(index));
            }

            @Override
            public int size() {
                return l.size();
            }
        };
    }

    @Override
    public void stop() {
        this.query("stop", new Object[0]);
    }

    @Override
    public String getRawChangeAddress() throws GenericRpcException {
        return (String)this.query("getrawchangeaddress", new Object[0]);
    }

    @Override
    public long getConnectionCount() throws GenericRpcException {
        return (Long)this.query("getconnectioncount", new Object[0]);
    }

    @Override
    public double getUnconfirmedBalance() throws GenericRpcException {
        return (Double)this.query("getunconfirmedbalance", new Object[0]);
    }

    @Override
    public double getDifficulty() throws GenericRpcException {
        if (this.query("getdifficulty", new Object[0]) instanceof Long) {
            return ((Long)this.query("getdifficulty", new Object[0])).doubleValue();
        }
        return (Double)this.query("getdifficulty", new Object[0]);
    }

    @Override
    public ThoughtClientInterface.NetTotals getNetTotals() throws GenericRpcException {
        return new NetTotalsImpl((Map)this.query("getnettotals", new Object[0]));
    }

    @Override
    public ThoughtClientInterface.DecodedScript decodeScript(String hex) throws GenericRpcException {
        return new DecodedScriptImpl((Map)this.query("decodescript", hex));
    }

    @Override
    public void ping() throws GenericRpcException {
        this.query("ping", new Object[0]);
    }

    @Override
    public boolean getGenerate() throws ThoughtRPCException {
        return (Boolean)this.query("getgenerate", new Object[0]);
    }

    @Override
    public double getNetworkHashPs() throws GenericRpcException {
        return (Double)this.query("getnetworkhashps", new Object[0]);
    }

    @Override
    public boolean setTxFee(BigDecimal amount) throws GenericRpcException {
        return (Boolean)this.query("settxfee", amount);
    }

    @Override
    public void addNode(String node, String command) throws GenericRpcException {
        this.query("addnode", node, command);
    }

    @Override
    public void backupWallet(String destination) throws GenericRpcException {
        this.query("backupwallet", destination);
    }

    @Override
    public String signMessage(String thoughtAdress, String message) throws GenericRpcException {
        return (String)this.query("signmessage", thoughtAdress, message);
    }

    @Override
    public void dumpWallet(String filename) throws GenericRpcException {
        this.query("dumpwallet", filename);
    }

    @Override
    public void importWallet(String filename) throws GenericRpcException {
        this.query("dumpwallet", filename);
    }

    @Override
    public void keyPoolRefill() throws GenericRpcException {
        this.keyPoolRefill(100L);
    }

    public void keyPoolRefill(long size) throws GenericRpcException {
        this.query("keypoolrefill", size);
    }

    @Override
    public BigDecimal getReceivedByAccount(String account) throws GenericRpcException {
        return this.getReceivedByAccount(account, 1);
    }

    public BigDecimal getReceivedByAccount(String account, int minConf) throws GenericRpcException {
        return new BigDecimal((String)this.query("getreceivedbyaccount", account, minConf));
    }

    @Override
    public void encryptWallet(String passPhrase) throws GenericRpcException {
        this.query("encryptwallet", passPhrase);
    }

    @Override
    public void walletPassPhrase(String passPhrase, long timeOut) throws GenericRpcException {
        this.query("walletpassphrase", passPhrase, timeOut);
    }

    @Override
    public boolean verifyMessage(String thoughtAddress, String signature, String message) throws GenericRpcException {
        return (Boolean)this.query("verifymessage", thoughtAddress, signature, message);
    }

    @Override
    public String addMultiSigAddress(int nRequired, List<String> keyObject) throws GenericRpcException {
        return (String)this.query("addmultisigaddress", nRequired, keyObject);
    }

    @Override
    public String addMultiSigAddress(int nRequired, List<String> keyObject, String account) throws GenericRpcException {
        return (String)this.query("addmultisigaddress", nRequired, keyObject, account);
    }

    @Override
    public boolean verifyChain() {
        return this.verifyChain(3, 6);
    }

    public boolean verifyChain(int checklevel, int numblocks) {
        return (Boolean)this.query("verifychain", checklevel, numblocks);
    }

    @Override
    public String submitBlock(String hexData) {
        return (String)this.query("submitblock", hexData);
    }

    @Override
    public ThoughtClientInterface.Transaction getTransaction(String txId) {
        return new TransactionWrapper((Map)this.query("gettransaction", txId));
    }

    @Override
    public ThoughtClientInterface.TxOut getTxOut(String txId, long vout) throws GenericRpcException {
        return new TxOutWrapper((Map)this.query("gettxout", txId, vout, true));
    }

    public ThoughtClientInterface.TxOut getTxOut(String txId, long vout, boolean includemempool) throws GenericRpcException {
        return new TxOutWrapper((Map)this.query("gettxout", txId, vout, includemempool));
    }

    @Override
    public List<ThoughtClientInterface.MasternodeOutput> masternodeOutputs() {
        ArrayList<ThoughtClientInterface.MasternodeOutput> retval = new ArrayList<ThoughtClientInterface.MasternodeOutput>();
        Map results = (Map)this.query("masternode", "status");
        Set keys = results.keySet();
        for (String key : keys) {
            MasternodeOutputImpl moi = new MasternodeOutputImpl();
            moi.txid = key;
            moi.vout = Integer.parseInt(results.get(key).toString());
            retval.add(moi);
        }
        return retval;
    }

    @Override
    public Map<String, ThoughtClientInterface.MasternodeInfo> masternodeList() {
        LinkedHashMap<String, ThoughtClientInterface.MasternodeInfo> retval = new LinkedHashMap<String, ThoughtClientInterface.MasternodeInfo>();
        Map results = (Map)this.query("masternode", "list");
        Set keys = results.keySet();
        for (Object key : keys) {
            retval.put((String)key, new MasternodeInfoImpl((Map)results.get(key)));
        }
        return retval;
    }

    static {
        String host;
        String password;
        String user;
        block10: {
            logger = Logger.getLogger(ThoughtRPCClient.class.getCanonicalName());
            user = DEFAULT_USER;
            password = DEFAULT_PASSWORD;
            host = DEFAULT_HOST;
            int port = 10617;
            try {
                File home = new File(System.getProperty("user.home"));
                File f = new File(home, ".thoughtcore" + File.separatorChar + "thought.conf");
                if (!f.exists() && !(f = new File(home, "AppData" + File.separatorChar + "Roaming" + File.separatorChar + "ThoughtCore" + File.separatorChar + "thought.conf")).exists()) {
                    f = null;
                }
                if (f == null) break block10;
                logger.fine("Thought configuration file found");
                Properties p = new Properties();
                try (FileInputStream i = new FileInputStream(f);){
                    p.load(i);
                }
                user = p.getProperty("rpcuser", user);
                password = p.getProperty("rpcpassword", password);
                host = p.getProperty("rpcconnect", host);
                String prt = p.getProperty("rpcport", Integer.toString(port));
                port = Integer.parseInt(prt);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        try {
            DEFAULT_JSONRPC_URL = new URL("http://" + user + ':' + password + "@" + host + ":" + Integer.toString(10617) + "/");
            DEFAULT_JSONRPC_TESTNET_URL = new URL("http://" + user + ':' + password + "@" + host + ":" + Integer.toString(11617) + "/");
            DEFAULT_JSONRPC_REGTEST_URL = new URL("http://" + user + ':' + password + "@" + host + ":" + Integer.toString(12617) + "/");
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        QUERY_CHARSET = Charset.forName("ISO8859-1");
        addrParam = new HashMap<String, Collection<String>>();
    }

    private class MasternodeInfoImpl
    implements ThoughtClientInterface.MasternodeInfo {
        Map map;

        public MasternodeInfoImpl(Map map) {
            this.map = map;
        }

        @Override
        public String address() {
            return (String)this.map.get("address");
        }

        @Override
        public String payee() {
            return (String)this.map.get("payee");
        }

        @Override
        public String status() {
            return (String)this.map.get("status");
        }

        @Override
        public String protocol() {
            return (String)this.map.get("protocol");
        }

        @Override
        public String daemonversion() {
            return (String)this.map.get("daemonversion");
        }

        @Override
        public String sentinelversion() {
            return (String)this.map.get("sentinelversion");
        }

        @Override
        public String sentinelstate() {
            return (String)this.map.get("sentinelstate");
        }

        @Override
        public long lastseen() {
            Long l = (Long)this.map.get("lastseen");
            return null == l ? 0L : l;
        }

        @Override
        public long activeseconds() {
            Long l = (Long)this.map.get("activeseconds");
            return null == l ? 0L : l;
        }

        @Override
        public long lastpaidtime() {
            Long l = (Long)this.map.get("lastpaidtime");
            return null == l ? 0L : l;
        }

        @Override
        public long lastpaidblock() {
            Long l = (Long)this.map.get("lastpaidblock");
            return null == l ? 0L : l;
        }

        @Override
        public String owneraddress() {
            return (String)this.map.get("owneraddress");
        }

        @Override
        public String votingaddress() {
            return (String)this.map.get("votingaddress");
        }
    }

    private class MasternodeOutputImpl
    implements ThoughtClientInterface.MasternodeOutput {
        String txid;
        int vout;

        private MasternodeOutputImpl() {
        }

        @Override
        public String txid() {
            return this.txid;
        }

        @Override
        public int vout() {
            return this.vout;
        }
    }

    private class PeerInfoWrapper
    extends MapWrapper
    implements ThoughtClientInterface.PeerInfoResult,
    Serializable {
        private static final long serialVersionUID = 1L;

        public PeerInfoWrapper(Map<?, ?> m) {
            super(m);
        }

        @Override
        public long getId() {
            return this.mapLong("id");
        }

        @Override
        public String getAddr() {
            return this.mapStr("addr");
        }

        @Override
        public String getAddrLocal() {
            return this.mapStr("addrlocal");
        }

        @Override
        public String getServices() {
            return this.mapStr("services");
        }

        @Override
        public long getLastSend() {
            return this.mapLong("lastsend");
        }

        @Override
        public long getLastRecv() {
            return this.mapLong("lastrecv");
        }

        @Override
        public long getBytesSent() {
            return this.mapLong("bytessent");
        }

        @Override
        public long getBytesRecv() {
            return this.mapLong("bytesrecv");
        }

        @Override
        public long getConnTime() {
            return this.mapLong("conntime");
        }

        @Override
        public int getTimeOffset() {
            return this.mapInt("timeoffset");
        }

        @Override
        public double getPingTime() {
            return this.mapDouble("pingtime");
        }

        @Override
        public long getVersion() {
            return this.mapLong("version");
        }

        @Override
        public String getSubVer() {
            return this.mapStr("subver");
        }

        @Override
        public boolean isInbound() {
            return this.mapBool("inbound");
        }

        @Override
        public int getStartingHeight() {
            return this.mapInt("startingheight");
        }

        @Override
        public long getBanScore() {
            return this.mapLong("banscore");
        }

        @Override
        public int getSyncedHeaders() {
            return this.mapInt("synced_headers");
        }

        @Override
        public int getSyncedBlocks() {
            return this.mapInt("synced_blocks");
        }

        @Override
        public boolean isWhiteListed() {
            return this.mapBool("whitelisted");
        }
    }

    private class UnspentWrapper
    extends MapWrapper
    implements ThoughtClientInterface.Unspent {
        private static final long serialVersionUID = 1L;

        UnspentWrapper(Map<?, ?> m) {
            super(m);
        }

        @Override
        public String txid() {
            return UnspentWrapper.mapStr(this.m, "txid");
        }

        @Override
        public int vout() {
            return UnspentWrapper.mapInt(this.m, "vout");
        }

        @Override
        public String address() {
            return UnspentWrapper.mapStr(this.m, "address");
        }

        @Override
        public String scriptPubKey() {
            return UnspentWrapper.mapStr(this.m, "scriptPubKey");
        }

        @Override
        public String account() {
            return UnspentWrapper.mapStr(this.m, "account");
        }

        @Override
        public double amount() {
            return MapWrapper.mapDouble(this.m, "amount");
        }

        @Override
        public int confirmations() {
            return UnspentWrapper.mapInt(this.m, "confirmations");
        }

        @Override
        public boolean spendable() {
            return UnspentWrapper.mapBool(this.m, "spendable");
        }

        @Override
        public boolean solvable() {
            return UnspentWrapper.mapBool(this.m, "solvable");
        }

        @Override
        public int ps_rounds() {
            return UnspentWrapper.mapInt(this.m, "ps_rounds");
        }

        @Override
        public String toString() {
            return this.m.toString();
        }
    }

    private class UnspentListWrapper
    extends ListMapWrapper<ThoughtClientInterface.Unspent> {
        public UnspentListWrapper(List<Map<?, ?>> list) {
            super(list);
        }

        @Override
        protected ThoughtClientInterface.Unspent wrap(Map<?, ?> m) {
            return new UnspentWrapper(m);
        }
    }

    private class TransactionsSinceBlockImpl
    implements ThoughtClientInterface.TransactionsSinceBlock,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final List<ThoughtClientInterface.Transaction> transactions;
        public final String lastBlock;

        public TransactionsSinceBlockImpl(Map<?, ?> r) {
            this.transactions = new TransactionListMapWrapper((List)r.get("transactions"));
            this.lastBlock = (String)r.get("lastblock");
        }

        @Override
        public List<ThoughtClientInterface.Transaction> transactions() {
            return this.transactions;
        }

        @Override
        public String lastBlock() {
            return this.lastBlock;
        }
    }

    private class TransactionListMapWrapper
    extends ListMapWrapper<ThoughtClientInterface.Transaction> {
        public TransactionListMapWrapper(List<Map<?, ?>> list) {
            super(list);
        }

        @Override
        protected ThoughtClientInterface.Transaction wrap(Map<?, ?> m) {
            return new TransactionWrapper(m);
        }
    }

    private static class ReceivedAddressListWrapper
    extends AbstractList<ThoughtClientInterface.ReceivedAddress> {
        private final List<Map<String, Object>> wrappedList;

        public ReceivedAddressListWrapper(List<Map<String, Object>> wrappedList) {
            this.wrappedList = wrappedList;
        }

        @Override
        public ThoughtClientInterface.ReceivedAddress get(int index) {
            final Map<String, Object> e = this.wrappedList.get(index);
            return new ThoughtClientInterface.ReceivedAddress(){
                private static final long serialVersionUID = 1L;

                @Override
                public String address() {
                    return (String)e.get("address");
                }

                @Override
                public String account() {
                    return (String)e.get("account");
                }

                @Override
                public double amount() {
                    return ((Number)e.get("amount")).doubleValue();
                }

                @Override
                public int confirmations() {
                    return ((Number)e.get("confirmations")).intValue();
                }

                public String toString() {
                    return e.toString();
                }
            };
        }

        @Override
        public int size() {
            return this.wrappedList.size();
        }
    }

    public class NetTotalsImpl
    extends MapWrapper
    implements ThoughtClientInterface.NetTotals,
    Serializable {
        private static final long serialVersionUID = 1L;

        public NetTotalsImpl(Map<?, ?> m) {
            super(m);
        }

        @Override
        public long totalBytesRecv() {
            return this.mapLong("totalbytesrecv");
        }

        @Override
        public long totalBytesSent() {
            return this.mapLong("totalbytessent");
        }

        @Override
        public long timeMillis() {
            return this.mapLong("timemillis");
        }

        @Override
        public ThoughtClientInterface.NetTotals.uploadTarget uploadTarget() {
            return new uploadTargetImpl((Map)this.m.get("uploadtarget"));
        }

        public class uploadTargetImpl
        extends MapWrapper
        implements ThoughtClientInterface.NetTotals.uploadTarget,
        Serializable {
            private static final long serialVersionUID = 1L;

            public uploadTargetImpl(Map<?, ?> m) {
                super(m);
            }

            @Override
            public long timeFrame() {
                return this.mapLong("timeframe");
            }

            @Override
            public int target() {
                return this.mapInt("target");
            }

            @Override
            public boolean targetReached() {
                return this.mapBool("targetreached");
            }

            @Override
            public boolean serveHistoricalBlocks() {
                return this.mapBool("servehistoricalblocks");
            }

            @Override
            public long bytesLeftInCycle() {
                return this.mapLong("bytesleftincycle");
            }

            @Override
            public long timeLeftInCycle() {
                return this.mapLong("timeleftincycle");
            }
        }
    }

    private class DecodedScriptImpl
    extends MapWrapper
    implements ThoughtClientInterface.DecodedScript,
    Serializable {
        private static final long serialVersionUID = 1L;

        public DecodedScriptImpl(Map m) {
            super(m);
        }

        @Override
        public String asm() {
            return this.mapStr("asm");
        }

        @Override
        public String hex() {
            return this.mapStr("hex");
        }

        @Override
        public String type() {
            return this.mapStr("type");
        }

        @Override
        public int reqSigs() {
            return this.mapInt("reqSigs");
        }

        @Override
        public List<String> addresses() {
            return (List)this.m.get("addresses");
        }

        @Override
        public String p2sh() {
            return this.mapStr("p2sh");
        }
    }

    private class RawTransactionImpl
    extends MapWrapper
    implements ThoughtClientInterface.RawTransaction,
    Serializable {
        private static final long serialVersionUID = 1L;

        public RawTransactionImpl(Map<?, ?> result) {
            super(result);
        }

        @Override
        public String hex() {
            return this.mapStr("hex");
        }

        @Override
        public String txId() {
            return this.mapStr("txid");
        }

        @Override
        public int version() {
            return this.mapInt("version");
        }

        @Override
        public long lockTime() {
            return this.mapLong("locktime");
        }

        @Override
        public String hash() {
            return this.mapStr("hash");
        }

        @Override
        public long size() {
            return this.mapLong("size");
        }

        @Override
        public long vsize() {
            return this.mapLong("vsize");
        }

        @Override
        public List<ThoughtClientInterface.RawTransaction.In> vIn() {
            final List vIn = (List)this.m.get("vin");
            return new AbstractList<ThoughtClientInterface.RawTransaction.In>(){

                @Override
                public ThoughtClientInterface.RawTransaction.In get(int index) {
                    return new InImpl((Map)vIn.get(index));
                }

                @Override
                public int size() {
                    return vIn.size();
                }
            };
        }

        @Override
        public List<ThoughtClientInterface.RawTransaction.Out> vOut() {
            final List vOut = (List)this.m.get("vout");
            return new AbstractList<ThoughtClientInterface.RawTransaction.Out>(){

                @Override
                public ThoughtClientInterface.RawTransaction.Out get(int index) {
                    return new OutImpl((Map)vOut.get(index));
                }

                @Override
                public int size() {
                    return vOut.size();
                }
            };
        }

        @Override
        public String blockHash() {
            return this.mapStr("blockhash");
        }

        @Override
        public int confirmations() {
            return this.mapInt("confirmations");
        }

        @Override
        public Date time() {
            return this.mapCTime("time");
        }

        @Override
        public Date blocktime() {
            return this.mapCTime("blocktime");
        }

        private class OutImpl
        extends MapWrapper
        implements ThoughtClientInterface.RawTransaction.Out,
        Serializable {
            private static final long serialVersionUID = 1L;

            public OutImpl(Map<?, ?> m) {
                super(m);
            }

            @Override
            public double value() {
                return this.mapDouble("value");
            }

            @Override
            public int n() {
                return this.mapInt("n");
            }

            @Override
            public ThoughtClientInterface.RawTransaction.Out.ScriptPubKey scriptPubKey() {
                return new ScriptPubKeyImpl((Map)this.m.get("scriptPubKey"));
            }

            @Override
            public ThoughtClientInterface.TxInput toInput() {
                return new ThoughtClientInterface.BasicTxInput(this.transaction().txId(), this.n());
            }

            @Override
            public ThoughtClientInterface.RawTransaction transaction() {
                return RawTransactionImpl.this;
            }

            private class ScriptPubKeyImpl
            extends MapWrapper
            implements ThoughtClientInterface.RawTransaction.Out.ScriptPubKey,
            Serializable {
                private static final long serialVersionUID = 1L;

                public ScriptPubKeyImpl(Map<?, ?> m) {
                    super(m);
                }

                @Override
                public String asm() {
                    return this.mapStr("asm");
                }

                @Override
                public String hex() {
                    return this.mapStr("hex");
                }

                @Override
                public int reqSigs() {
                    return this.mapInt("reqSigs");
                }

                @Override
                public String type() {
                    return this.mapStr("type");
                }

                @Override
                public List<String> addresses() {
                    return (List)this.m.get("addresses");
                }
            }
        }

        private class InImpl
        extends MapWrapper
        implements ThoughtClientInterface.RawTransaction.In,
        Serializable {
            private static final long serialVersionUID = 1L;

            public InImpl(Map<?, ?> m) {
                super(m);
            }

            @Override
            public String txid() {
                return this.mapStr("txid");
            }

            @Override
            public int vout() {
                return this.mapInt("vout");
            }

            @Override
            public Map<String, Object> scriptSig() {
                return (Map)this.m.get("scriptSig");
            }

            @Override
            public long sequence() {
                return this.mapLong("sequence");
            }

            @Override
            public ThoughtClientInterface.RawTransaction getTransaction() {
                try {
                    return ThoughtRPCClient.this.getRawTransaction(this.mapStr("txid"));
                }
                catch (GenericRpcException ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public ThoughtClientInterface.RawTransaction.Out getTransactionOutput() {
                return this.getTransaction().vOut().get(this.mapInt("vout"));
            }

            @Override
            public String scriptPubKey() {
                return this.mapStr("scriptPubKey");
            }

            @Override
            public boolean isCoinbase() {
                boolean retval = false;
                String cb = this.mapStr("coinbase");
                if (null != cb && cb.length() > 0) {
                    retval = true;
                }
                return retval;
            }

            @Override
            public String coinbase() {
                return this.mapStr("coinbase");
            }
        }
    }

    private class BlockMapWrapper
    extends MapWrapper
    implements ThoughtClientInterface.Block,
    Serializable {
        private static final long serialVersionUID = 1L;

        public BlockMapWrapper(Map<?, ?> m) {
            super(m);
        }

        @Override
        public String hash() {
            return this.mapStr("hash");
        }

        @Override
        public int confirmations() {
            return this.mapInt("confirmations");
        }

        @Override
        public int size() {
            return this.mapInt("size");
        }

        @Override
        public int height() {
            return this.mapInt("height");
        }

        @Override
        public int version() {
            return this.mapInt("version");
        }

        @Override
        public String merkleRoot() {
            return this.mapStr("merkleroot");
        }

        @Override
        public String chainwork() {
            return this.mapStr("chainwork");
        }

        @Override
        public List<String> tx() {
            return (List)this.m.get("tx");
        }

        @Override
        public Date time() {
            return this.mapCTime("time");
        }

        @Override
        public long nonce() {
            return this.mapLong("nonce");
        }

        @Override
        public String bits() {
            return this.mapStr("bits");
        }

        @Override
        public double difficulty() {
            return this.mapDouble("difficulty");
        }

        @Override
        public String previousHash() {
            return this.mapStr("previousblockhash");
        }

        @Override
        public String nextHash() {
            return this.mapStr("nextblockhash");
        }

        @Override
        public ThoughtClientInterface.Block previous() throws GenericRpcException {
            if (!this.m.containsKey("previousblockhash")) {
                return null;
            }
            return ThoughtRPCClient.this.getBlock(this.previousHash());
        }

        @Override
        public ThoughtClientInterface.Block next() throws GenericRpcException {
            if (!this.m.containsKey("nextblockhash")) {
                return null;
            }
            return ThoughtRPCClient.this.getBlock(this.nextHash());
        }
    }

    private class SmartFeeResultMapWrapper
    extends MapWrapper
    implements ThoughtClientInterface.SmartFeeResult,
    Serializable {
        private static final long serialVersionUID = 1L;

        public SmartFeeResultMapWrapper(Map<?, ?> m) {
            super(m);
        }

        @Override
        public double feeRate() {
            return this.mapDouble("feerate");
        }

        @Override
        public int blocks() {
            return this.mapInt("blocks");
        }
    }

    private class BlockChainInfoMapWrapper
    extends MapWrapper
    implements ThoughtClientInterface.BlockChainInfo,
    Serializable {
        private static final long serialVersionUID = 1L;

        public BlockChainInfoMapWrapper(Map<?, ?> m) {
            super(m);
        }

        @Override
        public String chain() {
            return this.mapStr("chain");
        }

        @Override
        public int blocks() {
            return this.mapInt("blocks");
        }

        @Override
        public String bestBlockHash() {
            return this.mapStr("bestblockhash");
        }

        @Override
        public double difficulty() {
            return this.mapDouble("difficulty");
        }

        @Override
        public double verificationProgress() {
            return this.mapDouble("verificationprogress");
        }

        @Override
        public String chainWork() {
            return this.mapStr("chainwork");
        }
    }

    private class BlockTemplateWrapper
    extends MapWrapper
    implements ThoughtClientInterface.BlockTemplate,
    Serializable {
        private static final long serialVersionUID = 1L;

        public BlockTemplateWrapper(Map<?, ?> m) {
            super(m);
        }

        @Override
        public List<String> capabilities() {
            return (List)this.m.get("capabilities");
        }

        @Override
        public long version() {
            return this.mapLong("version");
        }

        @Override
        public List<String> rules() {
            return (List)this.m.get("rules");
        }

        @Override
        public int vbrequired() {
            return this.mapInt("vbrequired");
        }

        @Override
        public String previousblockhash() {
            return this.mapStr("previousblockhash");
        }

        @Override
        public List<ThoughtClientInterface.BlockTemplateTransaction> transactions() {
            List maps = (List)this.m.get("transactions");
            LinkedList<ThoughtClientInterface.BlockTemplateTransaction> transactions = new LinkedList<ThoughtClientInterface.BlockTemplateTransaction>();
            for (Map m : maps) {
                BlockTemplateTransactionWrapper add = new BlockTemplateTransactionWrapper(m);
                transactions.add(add);
            }
            return transactions;
        }

        @Override
        public long coinbasevalue() {
            return this.mapLong("coinbasevalue");
        }

        @Override
        public String longpollid() {
            return this.mapStr("longpollid");
        }

        @Override
        public String target() {
            return this.mapStr("target");
        }

        @Override
        public long mintime() {
            return this.mapLong("mintime");
        }

        @Override
        public List<String> mutable() {
            return (List)this.m.get("mutable");
        }

        @Override
        public String noncerange() {
            return this.mapStr("noncerange");
        }

        @Override
        public long sigoplimit() {
            return this.mapLong("sigoplimit");
        }

        @Override
        public long sizelimit() {
            return this.mapLong("sizelimit");
        }

        @Override
        public long curtime() {
            return this.mapLong("curtime");
        }

        @Override
        public String bits() {
            return this.mapStr("bits");
        }

        @Override
        public long height() {
            return this.mapLong("height");
        }

        @Override
        public List<ThoughtClientInterface.Masternode> masternode() {
            List maps = (List)this.m.get("masternode");
            LinkedList<ThoughtClientInterface.Masternode> masternodes = new LinkedList<ThoughtClientInterface.Masternode>();
            for (Map m : maps) {
                MasternodeWrapper add = new MasternodeWrapper(m);
                masternodes.add(add);
            }
            return masternodes;
        }

        @Override
        public boolean masternode_payments_started() {
            return this.mapBool("masternode_payments_started");
        }

        @Override
        public boolean masternode_payments_enforced() {
            return this.mapBool("masternode_payments_enforced");
        }

        @Override
        public String coinbase_payload() {
            return this.mapStr("coinbase_payload");
        }
    }

    private class BlockTemplateTransactionWrapper
    extends MapWrapper
    implements ThoughtClientInterface.BlockTemplateTransaction,
    Serializable {
        private static final long serialVersionUID = 1L;

        public BlockTemplateTransactionWrapper(Map<?, ?> m) {
            super(m);
        }

        @Override
        public String data() {
            return this.mapStr("data");
        }

        @Override
        public String hash() {
            return this.mapStr("hash");
        }

        @Override
        public List<Long> depends() {
            return (List)this.m.get("depends");
        }

        @Override
        public long fee() {
            return this.mapLong("fee");
        }

        @Override
        public long sigops() {
            return this.mapLong("sigops");
        }

        @Override
        public boolean required() {
            return this.mapBool("required");
        }
    }

    private class MasternodeWrapper
    extends MapWrapper
    implements ThoughtClientInterface.Masternode,
    Serializable {
        private static final long serialVersionUID = 1L;

        public MasternodeWrapper(Map<?, ?> m) {
            super(m);
        }

        @Override
        public String payee() {
            return this.mapStr("payee");
        }

        @Override
        public String script() {
            return this.mapStr("script");
        }

        @Override
        public long amount() {
            return this.mapLong("amount");
        }
    }

    private class MiningInfoWrapper
    extends MapWrapper
    implements ThoughtClientInterface.MiningInfo,
    Serializable {
        private static final long serialVersionUID = 1L;

        public MiningInfoWrapper(Map<?, ?> m) {
            super(m);
        }

        @Override
        public int blocks() {
            return this.mapInt("blocks");
        }

        @Override
        public int currentBlockSize() {
            return this.mapInt("currentblocksize");
        }

        @Override
        public int currentBlockWeight() {
            return this.mapInt("currentblockweight");
        }

        @Override
        public int currentBlockTx() {
            return this.mapInt("currentblocktx");
        }

        @Override
        public double difficulty() {
            return this.mapDouble("difficulty");
        }

        @Override
        public String errors() {
            return this.mapStr("errors");
        }

        @Override
        public double networkHashps() {
            return Double.valueOf(this.mapStr("networkhashps"));
        }

        @Override
        public int pooledTx() {
            return this.mapInt("pooledtx");
        }

        @Override
        public boolean testNet() {
            return this.mapBool("testnet");
        }

        @Override
        public String chain() {
            return this.mapStr("chain");
        }
    }

    private class TxOutWrapper
    extends MapWrapper
    implements ThoughtClientInterface.TxOut,
    Serializable {
        private static final long serialVersionUID = 1L;

        public TxOutWrapper(Map<?, ?> m) {
            super(m);
        }

        @Override
        public String bestBlock() {
            return this.mapStr("bestblock");
        }

        @Override
        public long confirmations() {
            return this.mapLong("confirmations");
        }

        @Override
        public BigDecimal value() {
            return this.mapBigDecimal("value");
        }

        @Override
        public String asm() {
            return this.mapStr("asm");
        }

        @Override
        public String hex() {
            return this.mapStr("hex");
        }

        @Override
        public long reqSigs() {
            return this.mapLong("reqSigs");
        }

        @Override
        public String type() {
            return this.mapStr("type");
        }

        @Override
        public List<String> addresses() {
            return (List)this.m.get("addresses");
        }

        @Override
        public long version() {
            return this.mapLong("version");
        }

        @Override
        public boolean coinBase() {
            return this.mapBool("coinbase");
        }
    }

    private class TransactionWrapper
    extends MapWrapper
    implements ThoughtClientInterface.Transaction,
    Serializable {
        private static final long serialVersionUID = 1L;
        private ThoughtClientInterface.RawTransaction raw;

        public TransactionWrapper(Map<?, ?> m) {
            super(m);
            this.raw = null;
        }

        @Override
        public String account() {
            return TransactionWrapper.mapStr(this.m, "account");
        }

        @Override
        public String address() {
            return TransactionWrapper.mapStr(this.m, "address");
        }

        @Override
        public String category() {
            return TransactionWrapper.mapStr(this.m, "category");
        }

        @Override
        public double amount() {
            return TransactionWrapper.mapDouble(this.m, "amount");
        }

        @Override
        public double fee() {
            return TransactionWrapper.mapDouble(this.m, "fee");
        }

        @Override
        public boolean generated() {
            return TransactionWrapper.mapBool(this.m, "generated");
        }

        @Override
        public int confirmations() {
            return TransactionWrapper.mapInt(this.m, "confirmations");
        }

        @Override
        public String blockHash() {
            return TransactionWrapper.mapStr(this.m, "blockhash");
        }

        @Override
        public int blockIndex() {
            return TransactionWrapper.mapInt(this.m, "blockindex");
        }

        @Override
        public Date blockTime() {
            return TransactionWrapper.mapCTime(this.m, "blocktime");
        }

        @Override
        public String txId() {
            return TransactionWrapper.mapStr(this.m, "txid");
        }

        @Override
        public Date time() {
            return TransactionWrapper.mapCTime(this.m, "time");
        }

        @Override
        public Date timeReceived() {
            return TransactionWrapper.mapCTime(this.m, "timereceived");
        }

        @Override
        public List<ThoughtClientInterface.Transaction.Details> details() {
            List maps = (List)this.m.get("details");
            LinkedList<ThoughtClientInterface.Transaction.Details> details = new LinkedList<ThoughtClientInterface.Transaction.Details>();
            for (Map m : maps) {
                DetailsWrapper add = new DetailsWrapper(m);
                details.add(add);
            }
            return details;
        }

        @Override
        public String comment() {
            return TransactionWrapper.mapStr(this.m, "comment");
        }

        @Override
        public String commentTo() {
            return TransactionWrapper.mapStr(this.m, "to");
        }

        @Override
        public ThoughtClientInterface.RawTransaction raw() {
            if (this.raw == null) {
                try {
                    this.raw = ThoughtRPCClient.this.getRawTransaction(this.txId());
                }
                catch (GenericRpcException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return this.raw;
        }

        @Override
        public String toString() {
            return this.m.toString();
        }
    }

    private class DetailsWrapper
    extends MapWrapper
    implements ThoughtClientInterface.Transaction.Details,
    Serializable {
        private static final long serialVersionUID = 1L;

        public DetailsWrapper(Map<?, ?> m) {
            super(m);
        }

        @Override
        public String account() {
            return DetailsWrapper.mapStr(this.m, "account");
        }

        @Override
        public String address() {
            return DetailsWrapper.mapStr(this.m, "address");
        }

        @Override
        public String category() {
            return DetailsWrapper.mapStr(this.m, "category");
        }

        @Override
        public double amount() {
            return DetailsWrapper.mapDouble(this.m, "amount");
        }

        @Override
        public String label() {
            return DetailsWrapper.mapStr(this.m, "label");
        }

        @Override
        public int vout() {
            return DetailsWrapper.mapInt(this.m, "vout");
        }
    }

    private class AddressWrapper
    extends MapWrapper
    implements ThoughtClientInterface.Address,
    Serializable {
        private static final long serialVersionUID = 1L;

        public AddressWrapper(Map<?, ?> m) {
            super(m);
        }

        @Override
        public String address() {
            return this.mapStr("address");
        }

        @Override
        public String connected() {
            return this.mapStr("connected");
        }
    }

    private class NodeInfoWrapper
    extends MapWrapper
    implements ThoughtClientInterface.NodeInfo,
    Serializable {
        private static final long serialVersionUID = 1L;

        public NodeInfoWrapper(Map<?, ?> m) {
            super(m);
        }

        @Override
        public String addedNode() {
            return this.mapStr("addednode");
        }

        @Override
        public boolean connected() {
            return this.mapBool("connected");
        }

        @Override
        public List<ThoughtClientInterface.Address> addresses() {
            List maps = (List)this.m.get("addresses");
            LinkedList<ThoughtClientInterface.Address> addresses = new LinkedList<ThoughtClientInterface.Address>();
            for (Map m : maps) {
                AddressWrapper add = new AddressWrapper(m);
                addresses.add(add);
            }
            return addresses;
        }
    }

    private class MultiSigWrapper
    extends MapWrapper
    implements ThoughtClientInterface.MultiSig,
    Serializable {
        private static final long serialVersionUID = 1L;

        public MultiSigWrapper(Map<?, ?> m) {
            super(m);
        }

        @Override
        public String address() {
            return this.mapStr("address");
        }

        @Override
        public String redeemScript() {
            return this.mapStr("redeemScript");
        }
    }

    private class NetworkWrapper
    extends MapWrapper
    implements ThoughtClientInterface.Network,
    Serializable {
        private static final long serialVersionUID = 1L;

        public NetworkWrapper(Map<?, ?> m) {
            super(m);
        }

        @Override
        public String name() {
            return this.mapStr("name");
        }

        @Override
        public boolean limited() {
            return this.mapBool("limited");
        }

        @Override
        public boolean reachable() {
            return this.mapBool("reachable");
        }

        @Override
        public String proxy() {
            return this.mapStr("proxy");
        }

        @Override
        public boolean proxyRandomizeCredentials() {
            return this.mapBool("proxy_randomize_credentials");
        }
    }

    private class NetworkInfoWrapper
    extends MapWrapper
    implements ThoughtClientInterface.NetworkInfo,
    Serializable {
        private static final long serialVersionUID = 1L;

        public NetworkInfoWrapper(Map<?, ?> m) {
            super(m);
        }

        @Override
        public long version() {
            return this.mapLong("version");
        }

        @Override
        public String subversion() {
            return this.mapStr("subversion");
        }

        @Override
        public long protocolVersion() {
            return this.mapLong("protocolversion");
        }

        @Override
        public String localServices() {
            return this.mapStr("localservices");
        }

        @Override
        public boolean localRelay() {
            return this.mapBool("localrelay");
        }

        @Override
        public long timeOffset() {
            return this.mapLong("timeoffset");
        }

        @Override
        public long connections() {
            return this.mapLong("connections");
        }

        @Override
        public List<ThoughtClientInterface.Network> networks() {
            List maps = (List)this.m.get("networks");
            LinkedList<ThoughtClientInterface.Network> networks = new LinkedList<ThoughtClientInterface.Network>();
            for (Map m : maps) {
                NetworkWrapper net = new NetworkWrapper(m);
                networks.add(net);
            }
            return networks;
        }

        @Override
        public BigDecimal relayFee() {
            return this.mapBigDecimal("relayfee");
        }

        @Override
        public List<String> localAddresses() {
            return (List)this.m.get("localaddresses");
        }

        @Override
        public String warnings() {
            return this.mapStr("warnings");
        }
    }

    private class WalletInfoWrapper
    extends MapWrapper
    implements ThoughtClientInterface.WalletInfo,
    Serializable {
        private static final long serialVersionUID = 1L;

        public WalletInfoWrapper(Map m) {
            super(m);
        }

        @Override
        public long walletVersion() {
            return this.mapLong("walletversion");
        }

        @Override
        public BigDecimal balance() {
            return this.mapBigDecimal("balance");
        }

        @Override
        public BigDecimal unconfirmedBalance() {
            return this.mapBigDecimal("unconfirmed_balance");
        }

        @Override
        public BigDecimal immatureBalance() {
            return this.mapBigDecimal("immature_balance");
        }

        @Override
        public long txCount() {
            return this.mapLong("txcount");
        }

        @Override
        public long keyPoolOldest() {
            return this.mapLong("keypoololdest");
        }

        @Override
        public long keyPoolSize() {
            return this.mapLong("keypoolsize");
        }

        @Override
        public long unlockedUntil() {
            return this.mapLong("unlocked_until");
        }

        @Override
        public BigDecimal payTxFee() {
            return this.mapBigDecimal("paytxfee");
        }

        @Override
        public String hdMasterKeyId() {
            return this.mapStr("hdmasterkeyid");
        }
    }

    private class TxOutSetInfoWrapper
    extends MapWrapper
    implements ThoughtClientInterface.TxOutSetInfo,
    Serializable {
        private static final long serialVersionUID = 1L;

        public TxOutSetInfoWrapper(Map<?, ?> m) {
            super(m);
        }

        @Override
        public long height() {
            return this.mapInt("height");
        }

        @Override
        public String bestBlock() {
            return this.mapStr("bestBlock");
        }

        @Override
        public long transactions() {
            return this.mapInt("transactions");
        }

        @Override
        public long txouts() {
            return this.mapInt("txouts");
        }

        @Override
        public long bytesSerialized() {
            return this.mapInt("bytes_serialized");
        }

        @Override
        public String hashSerialized() {
            return this.mapStr("hash_serialized");
        }

        @Override
        public BigDecimal totalAmount() {
            return this.mapBigDecimal("total_amount");
        }
    }

    private class InfoWrapper
    extends MapWrapper
    implements ThoughtClientInterface.Info,
    Serializable {
        private static final long serialVersionUID = 1L;

        public InfoWrapper(Map<?, ?> m) {
            super(m);
        }

        @Override
        public double balance() {
            return this.mapDouble("balance");
        }

        @Override
        public int blocks() {
            return this.mapInt("blocks");
        }

        @Override
        public int connections() {
            return this.mapInt("connections");
        }

        @Override
        public double difficulty() {
            return this.mapDouble("difficulty");
        }

        @Override
        public String errors() {
            return this.mapStr("errors");
        }

        @Override
        public long keyPoolOldest() {
            return this.mapLong("keypoololdest");
        }

        @Override
        public long keyPoolSize() {
            return this.mapLong("keypoolsize");
        }

        @Override
        public double payTxFee() {
            return this.mapDouble("paytxfee");
        }

        @Override
        public long protocolVersion() {
            return this.mapLong("protocolversion");
        }

        @Override
        public String proxy() {
            return this.mapStr("proxy");
        }

        @Override
        public double relayFee() {
            return this.mapDouble("relayfee");
        }

        @Override
        public boolean testnet() {
            return this.mapBool("testnet");
        }

        @Override
        public int timeOffset() {
            return this.mapInt("timeoffset");
        }

        @Override
        public long version() {
            return this.mapLong("version");
        }

        @Override
        public long walletVersion() {
            return this.mapLong("walletversion");
        }
    }

    class FundedRawTransactionImpl
    extends MapWrapper
    implements ThoughtClientInterface.FundedRawTransaction {
        private static final long serialVersionUID = 1L;

        public FundedRawTransactionImpl(Map<?, ?> result) {
            super(result);
        }

        @Override
        public String hex() {
            return this.mapStr("hex");
        }

        @Override
        public double fee() {
            return this.mapDouble("fee");
        }

        @Override
        public int changepos() {
            return this.mapInt("changepos");
        }
    }
}

