/*
 * Decompiled with CFR 0.152.
 */
package live.thought.jtminer.algo;

import java.util.HashSet;
import live.thought.jtminer.algo.Cuckoo;
import live.thought.jtminer.algo.Edge;

public class CuckooSolve {
    public static final int MAXPATHLEN = 4096;
    Cuckoo graph;
    int easiness;
    int[] cuckoo;
    int nthreads;

    public CuckooSolve(byte[] hdr, int en, int nt) {
        this.graph = new Cuckoo(hdr);
        this.easiness = en;
        this.cuckoo = new int[0x1000001];
        assert (this.cuckoo != null);
        this.nthreads = nt;
    }

    public int path(int u, int[] us) {
        int nu = 0;
        while (u != 0) {
            if (++nu >= 4096) {
                Object msg = null;
                while (nu-- != 0 && us[nu] != u) {
                }
                msg = nu < 0 ? "maximum path length exceeded" : "illegal " + (4096 - nu) + "-cycle";
                throw new RuntimeException((String)msg);
            }
            us[nu] = u;
            u = this.cuckoo[u];
        }
        return nu;
    }

    public synchronized int[] solution(int[] us, int nu, int[] vs, int nv) {
        int[] retval = null;
        int[] sol = new int[42];
        HashSet<Edge> cycle = new HashSet<Edge>();
        cycle.add(new Edge(us[0], vs[0] - 0x800000));
        while (nu-- != 0) {
            cycle.add(new Edge(us[nu + 1 & 0xFFFFFFFE], us[nu | 1] - 0x800000));
        }
        while (nv-- != 0) {
            cycle.add(new Edge(vs[nv | 1], vs[nv + 1 & 0xFFFFFFFE] - 0x800000));
        }
        int n = 0;
        for (int nonce = 0; nonce < this.easiness; ++nonce) {
            Edge e = this.graph.sipedge(nonce);
            if (!cycle.contains(e)) continue;
            sol[n++] = nonce;
            cycle.remove(e);
        }
        if (n == 42) {
            retval = sol;
        }
        return retval;
    }

    public int getEasiness() {
        return this.easiness;
    }

    public int[] getCuckoo() {
        return this.cuckoo;
    }

    public int getNthreads() {
        return this.nthreads;
    }

    public Cuckoo getGraph() {
        return this.graph;
    }
}

