/*
 * Decompiled with CFR 0.152.
 */
package live.thought.jtminer;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import live.thought.jtminer.Miner;
import live.thought.jtminer.algo.SHA256d;
import live.thought.jtminer.data.BlockImpl;
import live.thought.jtminer.data.CoinbaseTransaction;
import live.thought.jtminer.data.DataUtils;
import live.thought.jtminer.data.PaymentObject;
import live.thought.thought4j.ThoughtClientInterface;

public class Work {
    private static final Logger LOG = Logger.getLogger(Work.class.getCanonicalName());
    long height;
    private BigInteger target;
    private BlockImpl block;
    private CoinbaseTransaction coinbaseTransaction;
    SHA256d localHasher = new SHA256d(32);

    public Work(ThoughtClientInterface.BlockTemplate blt) {
        this.height = blt.height();
        this.block = new BlockImpl(blt);
        this.coinbaseTransaction = new CoinbaseTransaction(blt.height(), blt.coinbasevalue(), Miner.getInstance().getCoinbaseAddress());
        if (null != Miner.getInstance().getScript()) {
            this.coinbaseTransaction.setCoinbaseScript(Miner.getInstance().getScript().getBytes());
        }
        try {
            if (blt.masternode_payments_started()) {
                List<ThoughtClientInterface.Masternode> outputs = blt.masternode();
                for (ThoughtClientInterface.Masternode m : outputs) {
                    PaymentObject p = new PaymentObject();
                    p.setPayee(m.payee());
                    p.setScript(m.script());
                    p.setValue(m.amount());
                    this.coinbaseTransaction.addExtraPayment(p);
                }
            }
        }
        catch (Exception outputs) {
            // empty catch block
        }
        try {
            String payload = blt.coinbase_payload();
            if (null != payload && payload.length() > 0) {
                this.coinbaseTransaction.setExtraPayload(payload);
            }
        }
        catch (Exception payload) {
            // empty catch block
        }
        this.block.setCoinbaseTransaction(this.coinbaseTransaction);
        BigInteger lBits = new BigInteger(DataUtils.hexStringToByteArray(blt.bits()));
        this.target = DataUtils.decodeCompactBits(lBits.longValue());
        LOG.setLevel(Level.ALL);
    }

    public boolean submit(ThoughtClientInterface client, int[] solution) throws IOException {
        boolean retval = false;
        this.block.setCuckooSolution(solution);
        String blockStr = DataUtils.byteArrayToHexString(this.block.getHex());
        try {
            this.localHasher.update(this.block.getHeader());
            String result = client.submitBlock(blockStr);
            if (null == result) {
                retval = true;
            } else {
                System.out.println(result);
            }
        }
        catch (Exception e) {
            LOG.severe(e.getMessage());
        }
        return retval;
    }

    public boolean meetsTarget(int nonce, int[] solution, SHA256d hasher) throws GeneralSecurityException {
        boolean retval = false;
        StringBuilder sb = new StringBuilder();
        for (int n = 0; n < solution.length; ++n) {
            sb.append(String.format("%08X", Integer.reverseBytes(solution[n])));
        }
        hasher.update(DataUtils.hexStringToByteArray(sb.toString()));
        byte[] hash = hasher.doubleDigest();
        BigInteger hashValue = new BigInteger(DataUtils.reverseBytes(hash));
        retval = hashValue.compareTo(BigInteger.ZERO) == -1 ? false : hashValue.compareTo(this.target) != 1;
        return retval;
    }

    public BlockImpl getBlock() {
        return this.block;
    }

    public BigInteger getTarget() {
        return this.target;
    }
}

