/*
 * Decompiled with CFR 0.152.
 */
package live.thought.jtminer.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import live.thought.jtminer.data.ByteArray;
import live.thought.jtminer.data.CoinbaseTransaction;
import live.thought.jtminer.data.DataUtils;
import live.thought.jtminer.data.Hexable;
import live.thought.jtminer.data.MerkleTree;
import live.thought.jtminer.data.TransactionImpl;
import live.thought.thought4j.ThoughtClientInterface;

public class BlockImpl
implements Hexable {
    private ThoughtClientInterface.Block block;
    protected String hash;
    protected int confirmations;
    protected int size;
    protected long height;
    protected long version;
    protected String merkleRoot;
    protected List<TransactionImpl> transactions;
    protected long time;
    protected long nonce;
    protected String bits;
    protected double difficulty;
    protected String previousHash;
    protected String chainwork;
    protected int[] cuckooSolution;
    protected int[] voteBits;
    protected CoinbaseTransaction coinbase;

    public BlockImpl(ThoughtClientInterface.Block block) {
        this.block = block;
        this.setHash(block.hash());
        this.setConfirmations(block.confirmations());
        this.setSize(block.size());
        this.setHeight(block.height());
        this.setVersion(block.version());
        this.setMerkleRoot(block.merkleRoot());
        this.setTime(block.time().getTime());
        this.setNonce(block.nonce());
        this.setBits(block.bits());
        this.setDifficulty(block.difficulty());
        this.setPreviousHash(block.previousHash());
        this.setChainwork(block.chainwork());
    }

    public BlockImpl(ThoughtClientInterface.BlockTemplate blt) {
        this.setHeight(blt.height());
        this.setVersion(blt.version());
        this.setTime(blt.curtime());
        this.setBits(blt.bits());
        this.setPreviousHash(blt.previousblockhash());
        List<ThoughtClientInterface.BlockTemplateTransaction> trans = blt.transactions();
        this.transactions = new ArrayList<TransactionImpl>(trans.size());
        for (ThoughtClientInterface.BlockTemplateTransaction t : trans) {
            this.transactions.add(new TransactionImpl(t));
        }
    }

    public BlockImpl(ThoughtClientInterface.BlockTemplate blt, List<Integer> voteBits) {
        this.setHeight(blt.height());
        this.setVersion(blt.version());
        this.setTime(blt.curtime());
        this.setBits(blt.bits());
        this.setPreviousHash(blt.previousblockhash());
        List<ThoughtClientInterface.BlockTemplateTransaction> trans = blt.transactions();
        this.transactions = new ArrayList<TransactionImpl>(trans.size());
        for (ThoughtClientInterface.BlockTemplateTransaction t : trans) {
            this.transactions.add(new TransactionImpl(t));
        }
        if (null != voteBits) {
            Iterator<Serializable> iterator = voteBits.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                this.addVoteBit(i);
            }
        }
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public int getConfirmations() {
        return this.confirmations;
    }

    public void setConfirmations(int confirmations) {
        this.confirmations = confirmations;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public String getMerkleRoot() {
        return this.merkleRoot;
    }

    public void setMerkleRoot(String merkleRoot) {
        this.merkleRoot = merkleRoot;
    }

    public List<TransactionImpl> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<TransactionImpl> transactions) {
        this.transactions = transactions;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getNonce() {
        return this.nonce;
    }

    public void setNonce(long nonce) {
        this.nonce = nonce;
    }

    public String getBits() {
        return this.bits;
    }

    public void setBits(String bits) {
        this.bits = bits;
    }

    public double getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(double difficulty) {
        this.difficulty = difficulty;
    }

    public String getPreviousHash() {
        return this.previousHash;
    }

    public void setPreviousHash(String previousHash) {
        this.previousHash = previousHash;
    }

    public String getChainwork() {
        return this.chainwork;
    }

    public void setChainwork(String chainwork) {
        this.chainwork = chainwork;
    }

    public ThoughtClientInterface.Block getBlock() {
        return this.block;
    }

    public void setCoinbaseTransaction(CoinbaseTransaction trans) {
        this.coinbase = trans;
    }

    public CoinbaseTransaction getCoinbaseTransaction() {
        return this.coinbase;
    }

    public int[] getCuckooSolution() {
        return this.cuckooSolution;
    }

    public void setCuckooSolution(int[] cuckooSolution) {
        this.cuckooSolution = cuckooSolution;
    }

    public void addVoteBit(int bit) {
        if (null == this.voteBits) {
            this.voteBits = new int[1];
            this.voteBits[0] = bit;
        } else {
            ArrayList<Integer> ints = new ArrayList<Integer>();
            for (int i : this.voteBits) {
                ints.add(i);
            }
            ints.add(bit);
            this.voteBits = new int[ints.size()];
            int j = 0;
            Iterator iterator = ints.iterator();
            while (iterator.hasNext()) {
                int i;
                this.voteBits[j] = i = ((Integer)iterator.next()).intValue();
                ++j;
            }
        }
    }

    public byte[] getHeader() {
        byte[] data = new byte[80];
        int offset = 0;
        if (null == this.voteBits) {
            DataUtils.uint32ToByteArrayLE(this.version, data, offset);
        } else {
            long t = 0x8000000L;
            for (int i : this.voteBits) {
                t |= (long)(1 << i);
            }
            long mask = 0xFFFFFFFFF0000000L & this.version;
            data[offset + 3] = (byte)(0xFFL & (t |= mask) >> 24);
            data[offset + 2] = (byte)(0xFFL & t >> 16);
            data[offset + 1] = (byte)(0xFFL & t >> 8);
            data[offset + 0] = (byte)(0xFFL & t >> 0);
        }
        byte[] prev = DataUtils.hexStringToByteArray(this.previousHash);
        System.arraycopy(DataUtils.reverseBytes(prev), 0, data, offset += 4, prev.length);
        MerkleTree mt = new MerkleTree(this.coinbase, this.getTransactions());
        byte[] merkle_bytes = mt.getRoot();
        System.arraycopy(DataUtils.reverseBytes(merkle_bytes), 0, data, offset += prev.length, merkle_bytes.length);
        DataUtils.uint32ToByteArrayLE(this.time, data, offset += merkle_bytes.length);
        byte[] bitsHex = DataUtils.reverseBytes(DataUtils.hexStringToByteArray(this.bits));
        System.arraycopy(bitsHex, 0, data, offset += 4, bitsHex.length);
        if (this.nonce != 0L) {
            data[79] = (byte)(this.nonce >> 0);
            data[78] = (byte)(this.nonce >> 8);
            data[77] = (byte)(this.nonce >> 16);
            data[76] = (byte)(this.nonce >> 24);
        }
        return data;
    }

    @Override
    public byte[] getHex() {
        byte[] header = this.getHeader();
        ByteArray bytes = new ByteArray(header);
        byte[] tmp = new byte[168];
        int off = 0;
        for (int i = 0; i < 42; ++i) {
            byte[] cnon = DataUtils.hexStringToByteArray(String.format("%08X", Integer.reverseBytes(this.cuckooSolution[i])));
            System.arraycopy(cnon, 0, tmp, off, 4);
            off += 4;
        }
        bytes.append(tmp);
        byte[] numTrans = DataUtils.encodeCompact(this.transactions.size() + 1);
        bytes.append(numTrans);
        bytes.append(this.coinbase.getHex());
        for (TransactionImpl t : this.transactions) {
            bytes.append(t.getHex());
        }
        return bytes.get();
    }
}

