/*
 * Decompiled with CFR 0.152.
 */
package live.thought.jtminer;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.atomic.AtomicBoolean;
import live.thought.jtminer.Miner;
import live.thought.jtminer.Notification;
import live.thought.jtminer.Work;
import live.thought.jtminer.algo.CuckooSolve;
import live.thought.jtminer.algo.SHA256d;
import live.thought.jtminer.util.Console;
import live.thought.thought4j.ThoughtClientInterface;

public class Solver
extends Observable
implements Observer,
Runnable {
    private int index;
    private CuckooSolve solve;
    private Work curWork;
    private ThoughtClientInterface client;
    private SHA256d hasher = new SHA256d(32);
    private AtomicBoolean stop = new AtomicBoolean();

    public Solver(ThoughtClientInterface client, Work curWork, int index, CuckooSolve solve) {
        this.solve = solve;
        this.index = index;
        this.curWork = curWork;
        this.client = client;
        this.stop.set(false);
    }

    public synchronized void stop() {
        Console.debug("Stopping solver " + this.index, 2);
        this.stop.set(true);
    }

    public void cleanup() {
        Miner.getInstance().getPoller().deleteObserver(this);
        this.deleteObserver(Miner.getInstance());
    }

    @Override
    public void run() {
        Console.debug("Starting solver " + this.index, 2);
        int[] cuckoo = this.solve.getCuckoo();
        int[] us = new int[4096];
        int[] vs = new int[4096];
        try {
            for (int nonce = this.index; nonce < this.solve.getEasiness(); nonce += this.solve.getNthreads()) {
                int nv;
                if (this.stop.get()) {
                    Thread.currentThread().interrupt();
                    break;
                }
                us[0] = this.solve.getGraph().sipnode(nonce, 0);
                int u = cuckoo[us[0]];
                vs[0] = 0x800000 + this.solve.getGraph().sipnode(nonce, 1);
                int v = cuckoo[vs[0]];
                if (u == vs[0] || v == us[0]) continue;
                int nu = this.solve.path(u, us);
                if (us[nu] == vs[nv = this.solve.path(v, vs)]) {
                    int[] soln;
                    int min = nu < nv ? nu : nv;
                    nu -= min;
                    nv -= min;
                    while (us[nu] != vs[nv]) {
                        ++nu;
                        ++nv;
                    }
                    int len = nu + nv + 1;
                    Miner.getInstance().incrementCycles();
                    if (len != 42 || null == (soln = this.solve.solution(us, nu, vs, nv))) continue;
                    Miner.getInstance().incrementSolutions();
                    try {
                        if (this.solve.getGraph().verify(soln, 0x1000000).booleanValue()) {
                            if (!this.curWork.meetsTarget(this.index, soln, this.hasher)) continue;
                            Console.debug("Trying to submit.", 2);
                            boolean success = this.curWork.submit(this.client, soln);
                            this.setChanged();
                            this.notifyObservers((Object)(success ? Notification.POW_TRUE : Notification.POW_FALSE));
                            this.stop();
                            break;
                        }
                        Miner.getInstance().incrementErrors();
                    }
                    catch (GeneralSecurityException e) {
                        Console.output(e.toString());
                    }
                    catch (IOException e) {
                        Console.output(e.toString());
                    }
                    continue;
                }
                if (nu < nv) {
                    while (nu-- != 0) {
                        cuckoo[us[nu + 1]] = us[nu];
                    }
                    cuckoo[us[0]] = vs[0];
                    continue;
                }
                while (nv-- != 0) {
                    cuckoo[vs[nv + 1]] = vs[nv];
                }
                cuckoo[vs[0]] = us[0];
            }
        }
        catch (RuntimeException re) {
            Console.debug("Illegal cycle.", 2);
        }
        this.cleanup();
        Console.debug("Exiting solver " + this.index, 2);
    }

    @Override
    public void update(Observable o, Object arg) {
        Notification n = (Notification)((Object)arg);
        if (n == Notification.NEW_WORK) {
            this.stop();
        }
    }
}

