{* modules/addons/powerdns_manager/templates/clientzone.tpl *}

<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><i class="fas fa-list"></i> {$zoneName} {$ADDONLANG.title}</h3>
        <div class="panel-actions pull-right">
            <div class="btn-group">
                <a href="index.php?m=powerdns_manager" class="btn btn-default btn-sm back-to-zones-btn">
                    <i class="fas fa-arrow-left"></i> {$ADDONLANG.back_to_zones}
                </a>
                <div class="btn-group" role="group" style="margin-left: 10px;">
                    <button class="btn btn-warning btn-sm" data-toggle="modal" data-target="#importZoneModal" style="border-top-left-radius: 8px; border-bottom-left-radius: 8px;">
                        <i class="fas fa-file-import"></i> {$ADDONLANG.import_zone}
                    </button>
                    <a href="index.php?m=powerdns_manager&action=viewzone&id={$zoneId}&export_zone=1" class="btn btn-info btn-sm" style="border-top-right-radius: 8px; border-bottom-right-radius: 8px;">
                        <i class="fas fa-file-export"></i> {$ADDONLANG.export_zone}
                    </a>
                </div>
                <button class="btn btn-success btn-sm add-record-btn" data-toggle="modal" data-target="#addRecordModal" style="margin-left: 10px;">
                    <i class="fas fa-plus"></i> {$ADDONLANG.add_record}
                </button>
            </div>
        </div>
    </div>
    <div class="panel-body">
        {if $error}
            <div class="alert alert-danger margin-bottom-20">
                {$error}
            </div>
        {/if}
        {if $success}
            <div class="alert alert-success margin-bottom-20">
                {$success}
            </div>
        {/if}
        <div class="table-container">
            <table class="table table-striped table-hover" id="dns-records-table">
                <thead>
                    <tr>
                        <th width="25%">{$ADDONLANG.name}</th>
                        <th width="10%">{$ADDONLANG.type}</th>
                        <th width="40%">{$ADDONLANG.content}</th>
                        <th width="10%">{$ADDONLANG.ttl}</th>
                        <th width="15%" class="text-center">{$ADDONLANG.actions}</th>
                    </tr>
                </thead>
                <tbody>
                    {foreach from=$records item=record}
                        <tr {if $record.disabled}class="text-muted"{/if} 
                            data-name="{$record.name}" 
                            data-type="{$record.type}" 
                            data-ttl="{$record.ttl}">
                            <td>
                                <strong>{$record.name}</strong>
                                {if $record.name == '@'}<span class="label label-info" style="color: white !important; background-color: #5bc0de !important;">{$ADDONLANG.zone_apex}</span>{/if}
                            </td>
                            <td>
                                {if $record.type == 'A'}
                                    <span class="label label-primary">{$record.type}</span>
                                {elseif $record.type == 'AAAA'}
                                    <span class="label label-warning">{$record.type}</span>
                                {elseif $record.type == 'CNAME'}
                                    <span class="label label-success">{$record.type}</span>
                                {elseif $record.type == 'MX'}
                                    <span class="label label-info mx-record">{$record.type}</span>
                                {elseif $record.type == 'TXT'}
                                    <span class="label label-default">{$record.type}</span>
                                {elseif $record.type == 'SRV'}
                                    <span class="label label-danger" style="background-color: #d9534f; border: 1px solid #c9302c;" title="{$ADDONLANG.srv_tooltip|default:'Service Record - Defines service location'}">{$record.type}</span>
                                {elseif $record.type == 'NS'}
                                    <span class="label record-ns">{$record.type}</span>
                                {elseif $record.type == 'CAA'}
                                    <span class="label record-caa">{$record.type}</span>
                                {elseif $record.type == 'TLSA'}
                                    <span class="label record-tlsa">{$record.type}</span>
                                {else}
                                    <span class="label label-default">{$record.type}</span>
                                {/if}
                            </td>
                            <td class="word-break-all record-content" data-raw-content="{$record.content|escape:'html'}">
                                {* Enhanced display for SRV records *}
                                {if $record.type == 'SRV'}
                                    {assign var="srv_parts" value=$record.content|regex_replace:'/^(\d+)\s+(\d+)\s+(\d+)\s+(.+)$/':'$1|$2|$3|$4'}
                                    {if $srv_parts|strpos:'|' !== false}
                                        {assign var="srv_array" value="|"|explode:$srv_parts}
                                        {if $srv_array|@count == 4}
                                            <div style="font-family: monospace; font-size: 12px; line-height: 1.4;">
                                                <strong>Priority:</strong> {$srv_array[0]} | 
                                                <strong>Weight:</strong> {$srv_array[1]} | 
                                                <strong>Port:</strong> {$srv_array[2]}<br>
                                                <strong>Target:</strong> {$srv_array[3]}
                                            </div>
                                            <div style="color: #999; font-size: 10px; margin-top: 3px;">
                                                Raw: {$record.content}
                                            </div>
                                        {else}
                                            {$record.content}
                                        {/if}
                                    {else}
                                        {$record.content}
                                    {/if}
                                {elseif $record.type == 'MX'}
                                    {assign var="mx_parts" value=$record.content|regex_replace:'/^(\d+)\s+(.+)$/':'$1|$2'}
                                    {if $mx_parts|strpos:'|' !== false}
                                        {assign var="mx_array" value="|"|explode:$mx_parts}
                                        {if $mx_array|@count == 2}
                                            <div style="font-family: monospace; font-size: 12px; line-height: 1.4;">
                                                <strong>Priority:</strong> {$mx_array[0]}<br>
                                                <strong>Mail Server:</strong> {$mx_array[1]}
                                            </div>
                                            <div style="color: #999; font-size: 10px; margin-top: 3px;">
                                                Raw: {$record.content}
                                            </div>
                                        {else}
                                            {$record.content}
                                        {/if}
                                    {else}
                                        {$record.content}
                                    {/if}
                                {elseif $record.type == 'TLSA'}
                                    {assign var="tlsa_parts" value=$record.content|regex_replace:'/^(\d+)\s+(\d+)\s+(\d+)\s+(.+)$/':'$1|$2|$3|$4'}
                                    {if $tlsa_parts|strpos:'|' !== false}
                                        {assign var="tlsa_array" value="|"|explode:$tlsa_parts}
                                        {if $tlsa_array|@count == 4}
                                            <div style="font-family: monospace; font-size: 12px; line-height: 1.4;">
                                                <strong>Usage:</strong> {$tlsa_array[0]} | 
                                                <strong>Selector:</strong> {$tlsa_array[1]} | 
                                                <strong>Match Type:</strong> {$tlsa_array[2]}<br>
                                                <strong>Certificate Data:</strong> {$tlsa_array[3]|truncate:40:"..."}
                                            </div>
                                            <div style="color: #999; font-size: 10px; margin-top: 3px;">
                                                Raw: {$record.content}
                                            </div>
                                        {else}
                                            {$record.content}
                                        {/if}
                                    {else}
                                        {$record.content}
                                    {/if}
                                {else}
                                    {$record.content}
                                {/if}
                                <textarea class="hidden-content" style="display:none;">{$record.content}</textarea>
                            </td>
                            <td>{$record.ttl}</td>
                            <td class="text-center">
                                {if $record.type == 'NS' && (
                                    $record.content == rtrim($ns1, '.')|cat:'.' || 
                                    $record.content == rtrim($ns2, '.')|cat:'.' || 
                                    ($ns3 && $record.content == rtrim($ns3, '.')|cat:'.') ||
                                    ($ns4 && $record.content == rtrim($ns4, '.')|cat:'.') ||
                                    ($ns5 && $record.content == rtrim($ns5, '.')|cat:'.')
                                )}
                                    <!-- Default NS records are immutable -->
                                    <button class="btn btn-sm btn-default" disabled title="{$ADDONLANG.default_ns_protected}">
                                        <i class="fas fa-lock"></i>
                                    </button>
                                {else}
                                    <!-- Always show Edit button, including for TXT -->
                                    <button class="btn btn-sm btn-default edit-record" data-toggle="modal" data-target="#editRecordModal"
                                        data-name="{$record.name}"
                                        data-type="{$record.type}"
                                        data-content="{$record.content|escape:'htmlall'}"
                                        data-ttl="{$record.ttl}">
                                        <i class="fas fa-pencil-alt"></i>
                                    </button>
                                    <!-- Show Delete button for TXT and others -->
                                    {if $record.type == 'TXT'}
                                        <a href="javascript:void(0);" class="btn btn-sm btn-danger delete-record" 
                                            data-name="{$record.name}" 
                                            data-type="{$record.type}" 
                                            data-content="{$record.content|escape:'htmlall'}">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    {else}
                                        <a href="index.php?m=powerdns_manager&action=viewzone&id={$zoneId}&delete_record=1&name={$record.name|urlencode}&type={$record.type|urlencode}&content={$record.content|urlencode}" class="btn btn-sm btn-danger" onclick="return confirm('{$ADDONLANG.delete_confirm}');">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    {/if}
                                {/if}
                            </td>
                        </tr>
                    {foreachelse}
                        <tr>
                            <td colspan="5" class="text-center">
                                <p><i class="fas fa-info-circle"></i> {$ADDONLANG.no_records}</p>
                            </td>
                        </tr>
                    {/foreach}
                </tbody>
            </table>
        </div>
    </div>
    <div class="panel-footer">
        <small><i class="fas fa-info-circle"></i> {$ADDONLANG.records_propagation}</small>
    </div>
</div>

{* DNSSEC Panel *}
{if $enableDNSSECUI}
<div class="panel panel-default margin-top-20" id="dnssec-panel">
    <div class="panel-heading">
        <h3 class="panel-title">
            <i class="fas fa-shield-alt"></i> {$ADDONLANG.dnssec_management}
        </h3>
        <div class="panel-actions pull-right">
            <div class="btn-group">
                <button class="btn btn-info btn-sm" id="validate-dnssec-btn">
                    <i class="fas fa-check-circle"></i> {$ADDONLANG.validate_dnssec|default:"Validate DNSSEC"}
                </button>
            </div>
        </div>
    </div>
    <div class="panel-body">
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label>
                        <strong>{$ADDONLANG.dnssec_status}:</strong>
                    </label>
                    <div class="dnssec-status-container">
                        {if $dnssecEnabled}
                            <span class="label label-success" id="dnssec-status">
                                <i class="fas fa-shield-alt"></i> {$ADDONLANG.dnssec_enabled}
                            </span>
                        {else}
                            <span class="label label-default" id="dnssec-status">
                                <i class="fas fa-shield-alt"></i> {$ADDONLANG.dnssec_disabled}
                            </span>
                        {/if}
                        <button class="btn btn-sm {if $dnssecEnabled}btn-danger{else}btn-success{/if} margin-left-10" id="toggle-dnssec">
                            {if $dnssecEnabled}
                                <i class="fas fa-times"></i> {$ADDONLANG.disable_dnssec}
                            {else}
                                <i class="fas fa-plus"></i> {$ADDONLANG.enable_dnssec}
                            {/if}
                        </button>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>
                        <strong>{$ADDONLANG.last_validated}:</strong>
                    </label>
                    <div>
                        <span id="last-validated">
                            {if $lastValidated}
                                {$lastValidated}
                            {else}
                                <em>{$ADDONLANG.never_validated}</em>
                            {/if}
                        </span>
                        <span id="validation-status" class="margin-left-10">
                            {if $validationStatus == 'valid'}
                                <span class="label label-success"><i class="fas fa-check"></i> {$ADDONLANG.validation_valid}</span>
                            {elseif $validationStatus == 'invalid'}
                                <span class="label label-danger"><i class="fas fa-times"></i> {$ADDONLANG.validation_invalid}</span>
                            {elseif $validationStatus == 'error'}
                                <span class="label label-warning"><i class="fas fa-exclamation-triangle"></i> {$ADDONLANG.validation_error}</span>
                            {else}
                                <span class="label label-default"><i class="fas fa-clock"></i> {$ADDONLANG.validation_pending}</span>
                            {/if}
                        </span>
                    </div>
                </div>
            </div>
        </div>

        {* Registrar Key Data Section *}
        {if $dnssecEnabled}
        <div class="dnssec-content" id="dnssec-content">
            <hr>
            <div class="row">
                <div class="col-md-12">
                    <h4><i class="fas fa-key"></i> {$ADDONLANG.registrar_keys}</h4>
                    <div class="alert alert-info">
                        <p>{$ADDONLANG.registrar_keys_help}</p>
                    </div>
                    <div id="registrar-keys-container">
                        {if $registrarKeyData}
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>{$ADDONLANG.key_type}</th>
                                            <th>{$ADDONLANG.flags}</th>
                                            <th>{$ADDONLANG.algorithm}</th>
                                            <th>{$ADDONLANG.public_key}</th>
                                            <th>{$ADDONLANG.key_tag}</th>
                                            <th>{$ADDONLANG.actions}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {foreach from=$registrarKeyData item=keyData}
                                        <tr>
                                            <td>
                                                <span class="label {if $keyData.keytype == 'KSK'}label-primary{else}label-success{/if}">
                                                    {$keyData.keytype}
                                                </span>
                                                {if $keyData.keytype == 'ZSK'}
                                                    <br><small class="text-success">← Most registrars want this</small>
                                                {/if}
                                            </td>
                                            <td><code>{$keyData.flags}</code></td>
                                            <td>
                                                <strong>{$keyData.algorithm}</strong><br>
                                                <small class="text-muted">{$keyData.algorithm_name}</small>
                                            </td>
                                            <td>
                                                <div class="input-group">
                                                    <input type="text" class="form-control public-key-field" value="{$keyData.public_key}" readonly>
                                                    <span class="input-group-btn">
                                                        <button class="btn btn-default copy-key-data" 
                                                                data-flags="{$keyData.flags}"
                                                                data-algorithm="{$keyData.algorithm}"
                                                                data-publickey="{$keyData.public_key}"
                                                                data-toggle="tooltip" 
                                                                title="{$ADDONLANG.copy_to_clipboard|default:'Copy to clipboard'}">
                                                            <i class="fas fa-copy"></i>
                                                        </button>
                                                    </span>
                                                </div>
                                                {if empty($keyData.public_key)}
                                                    <small class="text-danger">{$ADDONLANG.public_key_not_found}</small>
                                                {/if}
                                            </td>
                                            <td><code>{$keyData.key_tag}</code></td>
                                            <td>
                                                <button class="btn btn-xs btn-info show-full-dnskey" 
                                                        data-dnskey="{$keyData.raw_dnskey|escape:'htmlall'}"
                                                        data-toggle="tooltip" 
                                                        title="{$ADDONLANG.full_dnskey_record}">
                                                    <i class="fas fa-eye"></i> {$ADDONLANG.full_dnskey}
                                                </button>
                                            </td>
                                        </tr>
                                        {/foreach}
                                    </tbody>
                                </table>
                            </div>
                        {else}
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle"></i> {$ADDONLANG.registrar_keys_loading|default:"DNSSEC keys are being generated. Please refresh the page in a few moments."}
                            </div>
                        {/if}
                    </div>
                </div>
            </div>

            {* DS Records Section (Alternative for some registrars) *}
            <hr>
            <div class="row">
                <div class="col-md-12">
                    <h4><i class="fas fa-certificate"></i> {$ADDONLANG.ds_records}</h4>
                    <p class="help-block">
                        <i class="fas fa-info-circle"></i> 
                        {$ADDONLANG.ds_records_help}
                    </p>
                    <div id="ds-records-container">
                        {if $dsRecords}
                            {foreach from=$dsRecords item=dsRecord}
                            <div class="form-group">
                                <label>
                                    {$ADDONLANG.ds_record|default:"DS Record"} - {$ADDONLANG[$dsRecord.hash_name]|default:$dsRecord.hash_name}
                                    {if $dsRecord.recommended}<span class="label label-success">{$ADDONLANG.recommended}</span>{/if}
                                </label>
                                <div class="input-group">
                                    <input type="text" class="form-control ds-record-field" value="{$dsRecord.record}" readonly>
                                    <span class="input-group-btn">
                                        <button class="btn btn-default copy-ds-record" data-toggle="tooltip" title="{$ADDONLANG.copy_to_clipboard|default:'Copy to clipboard'}">
                                            <i class="fas fa-copy"></i>
                                        </button>
                                    </span>
                                </div>
                            </div>
                            {/foreach}
                        {else}
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle"></i> {$ADDONLANG.ds_records_loading|default:"DS records are being generated. Please refresh the page in a few moments."}
                            </div>
                        {/if}
                    </div>
                </div>
            </div>

        </div>
        {/if}
    </div>
</div>
{/if}

<!-- DNSKEY Details Modal -->
<div class="modal fade" id="dnskeyModal" tabindex="-1" role="dialog" aria-labelledby="dnskeyModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="dnskeyModalLabel">
                    <i class="fas fa-key"></i> {$ADDONLANG.full_dnskey_record}
                </h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <p class="help-block">
                    <i class="fas fa-info-circle"></i> 
{$ADDONLANG.full_dnskey_help}
                </p>
                <div class="form-group">
                    <label>{$ADDONLANG.full_dnskey_record}:</label>
                    <div class="input-group">
                        <textarea class="form-control" id="full-dnskey-content" rows="3" readonly></textarea>
                        <span class="input-group-btn">
                            <button class="btn btn-default" id="copy-full-dnskey" data-toggle="tooltip" title="Copy to clipboard">
                                <i class="fas fa-copy"></i>
                            </button>
                        </span>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Add Record Modal -->
<div class="modal fade" id="addRecordModal" tabindex="-1" role="dialog" aria-labelledby="addRecordModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="addRecordModalLabel" style="color: #222;"><i class="fas fa-plus" style="color: #0e83c8;"></i> {$ADDONLANG.add_record}</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <form method="post" action="index.php?m=powerdns_manager&action=viewzone&id={$zoneId}">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="record-name">{$ADDONLANG.name} <i class="fas fa-info-circle text-info tooltip-icon" data-toggle="tooltip" title="{$ADDONLANG.name_tooltip}"></i></label>
                        <input type="text" class="form-control" id="record-name" name="name" placeholder="@, www, mail">
                        <p class="help-block">{$ADDONLANG.use_at_symbol}</p>
                    </div>
                    
                    <div class="form-group">
                        <label for="record-type">{$ADDONLANG.type} <i class="fas fa-info-circle text-info tooltip-icon" data-toggle="tooltip" title="{$ADDONLANG.type_tooltip}"></i></label>
                        <select class="form-control" id="record-type" name="type">
                            <option value="A">A</option>
                            <option value="AAAA">AAAA</option>
                            <option value="CNAME">CNAME</option>
                            <option value="MX">MX</option>
                            <option value="TXT">TXT</option>
                            <option value="SRV">SRV</option>
                            <option value="CAA">CAA</option>
                            <option value="TLSA">TLSA</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="record-content">{$ADDONLANG.content} <i class="fas fa-info-circle text-info tooltip-icon" data-toggle="tooltip" title="{$ADDONLANG.content_tooltip}"></i></label>
                        <input type="text" class="form-control" id="record-content" name="content" placeholder="{$ADDONLANG.a_record_hint}">
                        <textarea class="form-control" id="record-content-txt" name="content_txt" rows="4" style="display:none;" placeholder="{$ADDONLANG.txt_record_hint}"></textarea>
                    </div>
                    
                    <div class="form-group">
                        <label for="record-ttl">{$ADDONLANG.ttl} <i class="fas fa-info-circle text-info tooltip-icon" data-toggle="tooltip" title="{$ADDONLANG.ttl_tooltip}"></i></label>
                        <input type="number" class="form-control" id="record-ttl" name="ttl" value="{$defaultTTL|default:3600}">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default back-to-zones-btn" data-dismiss="modal">{$ADDONLANG.cancel}</button>
                    <button type="submit" name="add_record" class="btn btn-primary">
                        <i class="fas fa-plus"></i> {$ADDONLANG.add_record}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Record Modal -->
<div class="modal fade" id="editRecordModal" tabindex="-1" role="dialog" aria-labelledby="editRecordModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="editRecordModalLabel" style="color: #222;"><i class="fas fa-pencil-alt" style="color: #0e83c8;"></i> {$ADDONLANG.edit_record}</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <form method="post" action="index.php?m=powerdns_manager&action=viewzone&id={$zoneId}">
                <div class="modal-body">
                    <input type="hidden" name="old_name" id="edit-old-name">
                    <input type="hidden" name="old_type" id="edit-old-type">
                    <input type="hidden" name="old_content" id="edit-old-content">
                    <input type="hidden" name="old_ttl" id="edit-old-ttl">
                    
                    <div class="form-group">
                        <label for="edit-name">{$ADDONLANG.name} <i class="fas fa-info-circle text-info tooltip-icon" data-toggle="tooltip" title="{$ADDONLANG.name_tooltip}"></i></label>
                        <input type="text" class="form-control" id="edit-name" name="name" required>
                        <p class="help-block">{$ADDONLANG.use_at_symbol}</p>
                    </div>
                    
                    <div class="form-group">
                        <label for="edit-type">{$ADDONLANG.type} <i class="fas fa-info-circle text-info tooltip-icon" data-toggle="tooltip" title="{$ADDONLANG.type_tooltip}"></i></label>
                        <select class="form-control" id="edit-type" name="type">
                            <option value="A">A</option>
                            <option value="AAAA">AAAA</option>
                            <option value="CNAME">CNAME</option>
                            <option value="MX">MX</option>
                            <option value="TXT">TXT</option>
                            <option value="SRV">SRV</option>
                            <option value="CAA">CAA</option>
                            <option value="TLSA">TLSA</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="edit-content">{$ADDONLANG.content} <i class="fas fa-info-circle text-info tooltip-icon" data-toggle="tooltip" title="{$ADDONLANG.content_tooltip}"></i></label>
                        <input type="text" class="form-control" id="edit-content" name="content">
                        <textarea class="form-control" id="edit-content-txt" name="content_txt" rows="4" style="display:none;"></textarea>
                    </div>
                    
                    <div class="form-group">
                        <label for="edit-ttl">{$ADDONLANG.ttl} <i class="fas fa-info-circle text-info tooltip-icon" data-toggle="tooltip" title="{$ADDONLANG.ttl_tooltip}"></i></label>
                        <input type="number" class="form-control" id="edit-ttl" name="ttl" value="{$defaultTTL|default:3600}">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default back-to-zones-btn" data-dismiss="modal">{$ADDONLANG.cancel}</button>
                    <button type="submit" name="edit_record" class="btn btn-primary">
                        <i class="fas fa-save"></i> {$ADDONLANG.save_changes}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Import Zone Modal -->
<div class="modal fade" id="importZoneModal" tabindex="-1" role="dialog" aria-labelledby="importZoneModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="importZoneModalLabel" style="color: #222;"><i class="fas fa-file-import" style="color: #f0ad4e;"></i> {$ADDONLANG.import_zone}</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <form method="post" action="index.php?m=powerdns_manager&action=viewzone&id={$zoneId}" id="importZoneForm" enctype="multipart/form-data">
                <input type="hidden" name="import_zone" value="1">
                <div class="modal-body">
                    <div class="alert alert-info">
                        <i class="fas fa-info-circle"></i> {$ADDONLANG.import_zone_help}
                    </div>
                    
                    <div class="form-group">
                        <label for="zone-content">{$ADDONLANG.zone_content} <i class="fas fa-info-circle text-info tooltip-icon" data-toggle="tooltip" title="{$ADDONLANG.zone_content_tooltip}"></i></label>
                        <textarea class="form-control" id="zone-content" name="zone_content" rows="15" placeholder="{$ADDONLANG.zone_content_placeholder}" required maxlength="50000"></textarea>
                        <p class="help-block">{$ADDONLANG.zone_content_help}</p>
                    </div>
                    
                    <div class="form-group">
                        <label>{$ADDONLANG.import_options}</label>
                        <div class="radio">
                            <label>
                                <input type="radio" name="import_mode" value="merge" checked>
                                <strong>{$ADDONLANG.import_mode_merge}</strong> - {$ADDONLANG.import_mode_merge_desc}
                            </label>
                        </div>
                        <div class="radio">
                            <label>
                                <input type="radio" name="import_mode" value="replace">
                                <strong>{$ADDONLANG.import_mode_replace}</strong> - {$ADDONLANG.import_mode_replace_desc}
                            </label>
                        </div>
                        <div class="radio">
                            <label>
                                <input type="radio" name="import_mode" value="append">
                                <strong>{$ADDONLANG.import_mode_append}</strong> - {$ADDONLANG.import_mode_append_desc}
                            </label>
                        </div>
                    </div>
                    
                    <div class="checkbox">
                        <label>
                            <input type="checkbox" name="preserve_soa" value="1" checked>
                            {$ADDONLANG.preserve_soa} <small class="text-muted">({$ADDONLANG.preserve_soa_help})</small>
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">{$ADDONLANG.cancel}</button>
                    <button type="submit" class="btn btn-warning" id="import-zone-btn">
                        <i class="fas fa-file-import"></i> {$ADDONLANG.import_zone}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>


<style type="text/css">
.margin-bottom-20 {
    margin-bottom: 20px;
}
.word-break-all {
    word-break: break-all;
}
.label-default {
    background-color: #777;
}
.label-info {
    background-color: #5bc0de;
}
.label {
    display: inline;
    padding: .2em .6em .3em;
    font-size: 75%;
    font-weight: 700;
    line-height: 1;
    color: #fff;
    text-align: center;
    white-space: nowrap;
    vertical-align: baseline;
    border-radius: .25em;
}
.record-ns {
    background-color: #9c27b0; /* Purple */
    color: #fff;
}
.record-caa {
    background-color: #009688; /* Teal */
    color: #fff;
}
textarea#edit-content-txt, 
textarea#record-content-txt {
    min-height: 100px;
    width: 100%;
    font-family: monospace;
}
.btn[disabled]:hover, .btn[disabled]:focus {
    background-color: #f5f5f5 !important;
    color: #888 !important;
    border-color: #ddd !important;
}
.btn[disabled] i.fas.fa-lock {
    color: #fff !important;
}
.btn[disabled]:hover i.fas.fa-lock, .btn[disabled]:focus i.fas.fa-lock {
    color: #888 !important;
}
.dataTables_filter input.form-control {
    border: 1.5px solid #0e83c8;
    background: #fff;
    color: #222;
    font-weight: 500;
    box-shadow: 0 2px 6px rgba(14,131,200,0.07);
    transition: border-color 0.2s;
}
.dataTables_filter input.form-control:focus {
    border-color: #095a8e;
    background: #f5faff;
    color: #111;
}
.back-to-zones-btn {
    background-color: #e0e0e0 !important;
    color: #333 !important;
    border-color: #bdbdbd !important;
    border-radius: 10px !important;
    font-weight: bold;
    margin-right: 5px;
}
.back-to-zones-btn:hover, .back-to-zones-btn:focus {
    background-color: #bdbdbd !important;
    color: #222 !important;
    border-color: #9e9e9e !important;
}

.add-record-btn {
    background-color: #0e83c8 !important;
    color: #fff !important;
    border-color: #0e83c8 !important;
    font-weight: bold;
    border-radius: 10px !important;
}
.add-record-btn:hover, .add-record-btn:focus {
    background-color: #095a8e !important;
    color: #fff !important;
    border-color: #095a8e !important;
}
.dataTables_info {
    display: none !important;
}
.tooltip-icon {
    cursor: pointer;
    margin-left: 4px;
}

/* Custom wider tooltip */
.tooltip-inner {
    max-width: 350px;
    width: 350px;
    text-align: left;
}

/* Responsive button group styling */
.panel-actions {
    margin-top: 0;
    float: right;
}

.panel-heading h3.panel-title {
    float: left;
    margin-top: 5px;
}

.panel-heading {
    overflow: hidden;
}

/* Search box spacing */
.dataTables_filter {
    margin-top: 20px;
}

@media (max-width: 991px) {
    .panel-actions {
        margin-top: 10px;
        float: none !important;
        text-align: center;
    }
    
    .panel-heading h3.panel-title {
        float: none;
        text-align: center;
        margin-top: 0;
    }
    
    .panel-title {
        text-align: center;
    }
    
    .btn-group {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 5px;
    }
    
    .btn-group > .btn {
        float: none;
        display: inline-block;
        margin: 0;
        border-radius: 10px !important;
    }
    
    .panel-heading {
        padding-bottom: 60px;
    }
}

@media (max-width: 480px) {
    .panel-heading {
        padding-bottom: 100px;
    }
    
    .btn-group {
        flex-direction: column;
        width: 100%;
    }
    
    .btn-group > .btn {
        width: 100%;
        margin-bottom: 5px;
    }
}

/* Modal styling */
.modal-title {
    color: #222 !important;
}
.modal-title i {
    color: #0e83c8 !important;
    margin-right: 5px;
}
#ns-check-loading i.fa-spinner {
    color: #0e83c8;
    margin-bottom: 15px;
}
#ns-check-loading p {
    color: #666;
    font-size: 16px;
}
#expected-ns-list li, #actual-ns-list li {
    margin-bottom: 8px;
    color: #444;
}
#expected-ns-list li i, #actual-ns-list li i {
    color: #0e83c8;
    margin-right: 8px;
}
#ns-check-status.alert-success {
    background-color: #dff0d8;
    border-color: #d6e9c6;
    color: #3c763d;
}
#ns-check-status.alert-danger {
    background-color: #f2dede;
    border-color: #ebccd1;
    color: #a94442;
}
#ns-check-status i {
    margin-right: 5px;
}
.modal-content {
    border-radius: 12px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
}
.modal-header {
    border-top-left-radius: 12px;
    border-top-right-radius: 12px;
    background-color: #f8f9fa;
    border-bottom: 1px solid #e9ecef;
}
.modal-footer {
    border-bottom-left-radius: 12px;
    border-bottom-right-radius: 12px;
    background-color: #f8f9fa;
    border-top: 1px solid #e9ecef;
}

.label-primary {
    background-color: #0e83c8 !important;
    color: #fff !important;
}

/* Reduce font size for table content for better data density */
#dns-records-table {
    font-size: 13px;
}

#dns-records-table td {
    font-size: 13px;
    line-height: 1.3;
    padding: 8px 12px;
}

#dns-records-table th {
    font-size: 14px;
    font-weight: 600;
}

/* TTL column - make it even more compact */
#dns-records-table td:nth-child(4) {
    font-size: 12px;
    font-family: monospace;
}

/* Content column - slightly smaller for long text */
#dns-records-table .record-content {
    font-size: 12px;
    line-height: 1.4;
}

/* Keep enhanced SRV/MX formatting slightly smaller */
#dns-records-table .record-content div[style*="monospace"] {
    font-size: 11px !important;
}

#dns-records-table .record-content div[style*="color: #999"] {
    font-size: 9px !important;
}

/* Better type badges with improved contrast and distinctiveness */
.label {
    font-size: 10px;
    font-weight: 500;
    padding: 2px 6px;
    border-radius: 2px;
    text-transform: uppercase;
    letter-spacing: 0.3px;
}

/* Custom colors for better visibility and distinction */
.label-primary { /* A records */
    background-color: #337ab7 !important;
    color: #fff !important;
}

.label-warning { /* AAAA records - better contrast */
    background-color: #ff6b35 !important; /* Bright orange-red */
    color: #fff !important;
}

.label-success { /* CNAME */
    background-color: #5cb85c !important;
    color: #fff !important;
}

.label-info { /* ZONE APEX labels */
    background-color: #eeeeee !important; /* Very light gray */
    color: #666 !important; /* Darker text for better contrast on light background */
}

/* MX records get their own distinct color */
.label-info.mx-record {
    background-color: #e67e22 !important; /* Distinct orange */
    color: #fff !important;
}

.label-default { /* TXT */
    background-color: #6c757d !important;
    color: #fff !important;
}

.label-danger { /* SRV - already well defined */
    background-color: #d9534f !important;
    color: #fff !important;
}

.record-ns { /* NS records */
    background-color: #9c27b0 !important;
    color: #fff !important;
}

.record-caa { /* CAA records */
    background-color: #00acc1 !important;
    color: #fff !important;
}

.record-tlsa { /* TLSA records */
    background-color: #ff5722 !important;
    color: #fff !important;
}

/* Add spacing for DataTables controls */
.dataTables_wrapper .dataTables_length,
.dataTables_wrapper .dataTables_filter {
    margin-top: 15px;
    margin-bottom: 15px;
}

.dataTables_wrapper .dataTables_length {
    margin-left: 15px;
}

.dataTables_wrapper .dataTables_filter {
    margin-right: 15px;
}

/* Add spacing for pagination controls */
.dataTables_wrapper .dataTables_paginate {
    margin-top: 8px !important;
    margin-bottom: 8px !important;
    margin-right: 8px !important;
    padding-right: 8px !important;
}

/* More specific targeting for pagination */
#dns-records-table_paginate {
    margin-top: 8px !important;
    margin-bottom: 8px !important;
    margin-right: 8px !important;
    padding-right: 8px !important;
}

/* Target the pagination ul directly */
.dataTables_paginate .pagination {
    margin-right: 8px !important;
    margin-bottom: 8px !important;
}

/* Make "Show ... records" text smaller */
.dataTables_wrapper .dataTables_length {
    font-size: 12px;
}

.dataTables_wrapper .dataTables_length select {
    font-size: 12px;
}

/* DNSSEC specific styles */
.margin-top-20 {
    margin-top: 20px;
}

.margin-left-10 {
    margin-left: 10px;
}

.dnssec-status-container {
    display: flex;
    align-items: center;
    flex-wrap: wrap;
    gap: 10px;
}

#dnssec-panel .panel-heading {
    background-color: #f8f9fa;
    border-bottom: 2px solid #e9ecef;
}

#dnssec-panel .panel-title i {
    color: #28a745;
    margin-right: 8px;
}

.ds-record-field,
.public-key-field {
    font-family: monospace;
    font-size: 12px;
    background-color: #f8f9fa;
}

.public-key-field {
    font-size: 10px;
    word-break: break-all;
}

.copy-ds-record {
    transition: all 0.3s ease;
}

.copy-ds-record:hover {
    background-color: #e9ecef;
}

#dnssec-records-table {
    font-size: 12px;
}

#dnssec-records-table .word-break-all {
    word-break: break-all;
    font-family: monospace;
    font-size: 11px;
}

/* DNSSEC record type colors */
.label-primary { /* DNSKEY */
    background-color: #007bff !important;
}

.label-info { /* RRSIG */
    background-color: #17a2b8 !important;
}

.label-warning { /* NSEC/NSEC3 */
    background-color: #ffc107 !important;
    color: #212529 !important;
}

/* Responsive adjustments for DNSSEC panel */
@media (max-width: 768px) {
    .dnssec-status-container {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .margin-left-10 {
        margin-left: 0;
        margin-top: 10px;
    }
    
    .ds-record-field {
        font-size: 11px;
    }
}

</style>

<script type="text/javascript">
jQuery(document).ready(function($) {
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip({
        container: 'body',
        html: true,
        placement: 'auto',
        template: '<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>'
    });
    
    // Initialize DataTables if available
    if ($.fn.DataTable) {
        var dnsTable = $('#dns-records-table').DataTable({
            "pageLength": 10,
            "order": [[0, "asc"], [1, "asc"]],
            "stateSave": true,
            "responsive": true,
            "autoWidth": false,
            "columnDefs": [
                { "width": "25%", "targets": 0 },
                { "width": "10%", "targets": 1 },
                { "width": "40%", "targets": 2 },
                { "width": "10%", "targets": 3 },
                { "width": "15%", "targets": 4 }
            ],
            "language": {
                "search": "",
                "searchPlaceholder": "{$ADDONLANG.search_records}",
                "emptyTable": "{$ADDONLANG.no_dns_zones}",
                "zeroRecords": "{$ADDONLANG.no_matching_zones}",
                "lengthMenu": "{$ADDONLANG.show_records}"
            },
            "dom": '<"row"<"col-sm-6"l><"col-sm-6"f>>rt<"row"<"col-sm-6"i><"col-sm-6"p>>',
            "fnDrawCallback": function() {
                $('.dataTables_filter input').addClass('form-control');
                $('.dataTables_length select').addClass('form-control');
            }
        });
    }
    
    // Change placeholder based on record type
    $('#record-type').change(function() {
        var type = $(this).val();
        updatePlaceholder($(this), $('#record-content'));
        
        // Toggle between text input and textarea for TXT records
        if (type === 'TXT') {
            $('#record-content').hide().removeAttr('required');
            $('#record-content-txt').show().attr('required', 'required');
        } else {
            $('#record-content').show().attr('required', 'required');
            $('#record-content-txt').hide().removeAttr('required');
        }
    });
    
    $('#edit-type').change(function() {
        var type = $(this).val();
        updatePlaceholder($(this), $('#edit-content'));
        
        // Toggle between text input and textarea for TXT records
        if (type === 'TXT') {
            $('#edit-content').hide().removeAttr('required');
            $('#edit-content-txt').show().attr('required', 'required');
        } else {
            $('#edit-content').show().attr('required', 'required');
            $('#edit-content-txt').hide().removeAttr('required');
        }
    });
    
    function updatePlaceholder(typeField, contentField) {
        var type = typeField.val();
        
        switch(type) {
            case "A":
                contentField.attr("placeholder", "{$ADDONLANG.a_record_hint}");
                break;
            case "AAAA":
                contentField.attr("placeholder", "{$ADDONLANG.aaaa_record_hint}");
                break;
            case "CNAME":
                contentField.attr("placeholder", "{$ADDONLANG.cname_record_hint}");
                break;
            case "MX":
                contentField.attr("placeholder", "{$ADDONLANG.mx_record_hint}");
                break;
            case "TXT":
                contentField.attr("placeholder", "{$ADDONLANG.txt_record_hint}");
                break;
            case "SRV":
                contentField.attr("placeholder", "{$ADDONLANG.srv_record_hint}");
                break;
            case "NS":
                contentField.attr("placeholder", "{$ADDONLANG.ns_record_hint}");
                break;
            case "CAA":
                contentField.attr("placeholder", "0 issue \"letsencrypt.org\"");
                break;
            case "TLSA":
                contentField.attr("placeholder", "3 1 1 1234567890abcdef...");
                break;
        }
    }
    
    // Function to decode HTML entities properly
    function decodeHtmlEntities(input) {
        if (!input || typeof input !== 'string') return '';
        
        var textarea = document.createElement('textarea');
        textarea.innerHTML = input;
        return textarea.value;
    }
    
    // Edit record functionality
    $(document).on('click', '.edit-record', function() {
        var name = $(this).data('name');
        var type = $(this).data('type');
        var content = $(this).data('content');
        var ttl = $(this).data('ttl');
        // Decode HTML entities
        content = decodeHtmlEntities(content);
        $('#edit-old-name').val(name);
        $('#edit-old-type').val(type);
        $('#edit-old-content').val(content);
        $('#edit-old-ttl').val(ttl);
        $('#edit-name').val(name);
        $('#edit-type').val(type);
        if (type === 'TXT') {
            $('#edit-content').hide().removeAttr('required');
            $('#edit-content-txt').show().attr('required', 'required').val(content);
        } else {
            $('#edit-content').show().attr('required', 'required').val(content);
            $('#edit-content-txt').hide().removeAttr('required');
        }
        $('#edit-ttl').val(ttl);
        updatePlaceholder($('#edit-type'), $('#edit-content'));
    });
    
    // Form submission handling for edit
    $('#editRecordModal form').on('submit', function(e) {
        // Clear previous validation errors
        $('#edit-validation-error').remove();
        
        // Simple CNAME validation
        if ($('#edit-type').val() === 'CNAME') {
            var content = $('#edit-content').val().trim();
            if (/^\d+\.\d+/.test(content)) {
                e.preventDefault();
                $('#editRecordModal .modal-body').prepend('<div id="edit-validation-error" class="alert alert-danger"><i class="fas fa-exclamation-triangle"></i> CNAME records must point to a domain name, not an IP address.</div>');
                return false;
            }
        }
        
        // Make sure the right content field is used for submission
        if ($('#edit-type').val() === 'TXT') {
            var txtContent = $.trim($('#edit-content-txt').val());
            
            // Remove any existing double quotes at the beginning and end if present
            if (txtContent.charAt(0) === '"' && txtContent.charAt(txtContent.length - 1) === '"') {
                txtContent = txtContent.substring(1, txtContent.length - 1);
            }
            
            $('#edit-content').val(txtContent);
            
            // Add a hidden field with the raw content to ensure it gets submitted correctly
            if (!$('#edit-txt-content-hidden').length) {
                $(this).append('<input type="hidden" id="edit-txt-content-hidden" name="txt_content" value="">');
            }
            $('#edit-txt-content-hidden').val(txtContent);
        }
        
        // Clean record name - remove any domain suffix and trailing dots
        var recordName = $('#edit-name').val();
        recordName = recordName.replace(/\.$/, ''); // Remove any trailing dots
        recordName = recordName.replace(/{$zoneName}$/, ''); // Remove domain if present
        $('#edit-name').val(recordName);
        
        return true;
    });
    
    // Form submission handling for add
    $('#addRecordModal form').on('submit', function(e) {
        // Clear previous validation errors
        $('#add-validation-error').remove();
        
        // Simple CNAME validation
        if ($('#record-type').val() === 'CNAME') {
            var content = $('#record-content').val().trim();
            if (/^\d+\.\d+/.test(content)) {
                e.preventDefault();
                $('#addRecordModal .modal-body').prepend('<div id="add-validation-error" class="alert alert-danger"><i class="fas fa-exclamation-triangle"></i> CNAME records must point to a domain name, not an IP address.</div>');
                return false;
            }
        }
        
        // Make sure the right content field is used for submission
        if ($('#record-type').val() === 'TXT') {
            var txtContent = $.trim($('#record-content-txt').val());
            
            // Remove any existing double quotes at the beginning and end if present
            if (txtContent.charAt(0) === '"' && txtContent.charAt(txtContent.length - 1) === '"') {
                txtContent = txtContent.substring(1, txtContent.length - 1);
            }
            
            $('#record-content').val(txtContent);
            
            // Add a hidden field with the raw content to ensure it gets submitted correctly
            if (!$('#add-txt-content-hidden').length) {
                $(this).append('<input type="hidden" id="add-txt-content-hidden" name="txt_content" value="">');
            }
            $('#add-txt-content-hidden').val(txtContent);
        }
        
        // Clean record name - remove any domain suffix and trailing dots
        var recordName = $('#record-name').val();
        recordName = recordName.replace(/\.$/, ''); // Remove any trailing dots
        recordName = recordName.replace(/{$zoneName}$/, ''); // Remove domain if present
        $('#record-name').val(recordName);
        
        return true;
    });
    
    // Initialize placeholder for add record
    updatePlaceholder($('#record-type'), $('#record-content'));
    
    // Handle TXT record deletion with a custom approach
    $(document).on('click', '.delete-record', function(e) {
        var type = $(this).data('type');
        if (type === 'TXT') {
            e.preventDefault();
            if (confirm('{$ADDONLANG.delete_confirm}')) {
                var name = $(this).data('name');
                var content = $(this).data('content');
                var $form = $('<form>', {
                    action: 'index.php',
                    method: 'get'
                });
                $form.append($('<input>', { type: 'hidden', name: 'm', value: 'powerdns_manager' }));
                $form.append($('<input>', { type: 'hidden', name: 'action', value: 'viewzone' }));
                $form.append($('<input>', { type: 'hidden', name: 'id', value: '{$zoneId}' }));
                $form.append($('<input>', { type: 'hidden', name: 'delete_record', value: '1' }));
                $form.append($('<input>', { type: 'hidden', name: 'name', value: name }));
                $form.append($('<input>', { type: 'hidden', name: 'type', value: type }));
                $form.append($('<input>', { type: 'hidden', name: 'content', value: content }));
                $('body').append($form);
                $form.submit();
            }
            return false;
        }
    });
    
    // Handle modal events to ensure correct field visibility
    $('#addRecordModal').on('show.bs.modal', function () {
        var type = $('#record-type').val();
        if (type === 'TXT') {
            $('#record-content').hide().removeAttr('required');
            $('#record-content-txt').show().attr('required', 'required');
        } else {
            $('#record-content').show().attr('required', 'required');
            $('#record-content-txt').hide().removeAttr('required');
        }
    });
    
    $('#editRecordModal').on('show.bs.modal', function () {
        var type = $('#edit-type').val();
        if (type === 'TXT') {
            $('#edit-content').hide().removeAttr('required');
            $('#edit-content-txt').show().attr('required', 'required');
        } else {
            $('#edit-content').show().attr('required', 'required');
            $('#edit-content-txt').hide().removeAttr('required');
        }
    });
    
    // DNSSEC functionality
    $('#toggle-dnssec').click(function() {
        var $btn = $(this);
        var isEnabled = $btn.hasClass('btn-danger');
        var action = isEnabled ? 'disable' : 'enable';
        var confirmMsg = isEnabled ? 
            '{$ADDONLANG.confirm_disable_dnssec|default:"Are you sure you want to disable DNSSEC? This will remove all DNSSEC records."}' :
            '{$ADDONLANG.confirm_enable_dnssec|default:"Are you sure you want to enable DNSSEC? This will generate cryptographic keys."}';
        
        if (!confirm(confirmMsg)) {
            return;
        }
        
        $btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Processing...');
        
        $.ajax({
            url: 'index.php?m=powerdns_manager&action=viewzone&id={$zoneId}',
            method: 'POST',
            data: {
                dnssec_action: action,
                zone_name: '{$zoneName}'
            },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    // Reload the page to show updated status
                    location.reload();
                } else {
                    alert('Error: ' + (response.error || 'Unknown error occurred'));
                    $btn.prop('disabled', false).html(isEnabled ? 
                        '<i class="fas fa-times"></i> {$ADDONLANG.disable_dnssec|default:"Disable DNSSEC"}' :
                        '<i class="fas fa-plus"></i> {$ADDONLANG.enable_dnssec|default:"Enable DNSSEC"}'
                    );
                }
            },
            error: function() {
                alert('Communication error occurred');
                $btn.prop('disabled', false).html(isEnabled ? 
                    '<i class="fas fa-times"></i> {$ADDONLANG.disable_dnssec|default:"Disable DNSSEC"}' :
                    '<i class="fas fa-plus"></i> {$ADDONLANG.enable_dnssec|default:"Enable DNSSEC"}'
                );
            }
        });
    });
    
    // Validate DNSSEC functionality
    $('#validate-dnssec-btn').click(function() {
        var $btn = $(this);
        $btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Validating...');
        
        $.ajax({
            url: 'index.php?m=powerdns_manager&action=viewzone&id={$zoneId}',
            method: 'POST',
            data: {
                dnssec_action: 'validate',
                zone_name: '{$zoneName}'
            },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    // Update validation status display
                    $('#last-validated').text(response.validated_at || 'Just now');
                    
                    var statusHtml = '';
                    if (response.validation_result.overall_valid) {
                        statusHtml = '<span class="label label-success"><i class="fas fa-check"></i> {$ADDONLANG.validation_valid|default:"Valid"}</span>';
                    } else {
                        statusHtml = '<span class="label label-danger"><i class="fas fa-times"></i> {$ADDONLANG.validation_invalid|default:"Invalid"}</span>';
                    }
                    $('#validation-status').html(statusHtml);
                    
                    // Show detailed results in a modal or alert
                    var details = 'Validation Results:\n';
                    details += 'Valid servers: ' + response.validation_result.valid_servers + '/' + response.validation_result.total_servers + '\n\n';
                    
                    for (var server in response.validation_result.results) {
                        var result = response.validation_result.results[server];
                        details += server + ': ' + (result.valid ? 'Valid' : 'Invalid') + '\n';
                    }
                    
                    alert(details);
                } else {
                    alert('Validation Error: ' + (response.error || 'Unknown error occurred'));
                }
                
                $btn.prop('disabled', false).html('<i class="fas fa-check-circle"></i> {$ADDONLANG.validate_dnssec|default:"Validate DNSSEC"}');
            },
            error: function() {
                alert('Communication error during validation');
                $btn.prop('disabled', false).html('<i class="fas fa-check-circle"></i> {$ADDONLANG.validate_dnssec|default:"Validate DNSSEC"}');
            }
        });
    });
    
    // Copy DS record functionality
    $(document).on('click', '.copy-ds-record', function() {
        var $input = $(this).closest('.input-group').find('.ds-record-field');
        $input.select();
        
        try {
            var successful = document.execCommand('copy');
            if (successful) {
                var $btn = $(this);
                var originalHtml = $btn.html();
                $btn.html('<i class="fas fa-check"></i>').addClass('btn-success').removeClass('btn-default');
                
                setTimeout(function() {
                    $btn.html(originalHtml).removeClass('btn-success').addClass('btn-default');
                }, 2000);
            } else {
                alert('Copy failed. Please manually select and copy the DS record.');
            }
        } catch (err) {
            // Fallback for older browsers
            alert('Please manually select and copy the DS record.');
        }
    });
    
    // Copy key data functionality for registrar input
    $(document).on('click', '.copy-key-data', function() {
        var $input = $(this).closest('.input-group').find('.public-key-field');
        $input.select();
        
        try {
            var successful = document.execCommand('copy');
            if (successful) {
                var $btn = $(this);
                var originalHtml = $btn.html();
                $btn.html('<i class="fas fa-check"></i>').addClass('btn-success').removeClass('btn-default');
                
                setTimeout(function() {
                    $btn.html(originalHtml).removeClass('btn-success').addClass('btn-default');
                }, 2000);
            } else {
                alert('Copy failed. Please manually select and copy the public key.');
            }
        } catch (err) {
            // Fallback for older browsers
            alert('Please manually select and copy the public key.');
        }
    });
    
    // Show full DNSKEY record
    $(document).on('click', '.show-full-dnskey', function() {
        var dnskeyRecord = $(this).data('dnskey');
        $('#full-dnskey-content').val(dnskeyRecord);
        $('#dnskeyModal').modal('show');
    });
    
    // Copy full DNSKEY record
    $('#copy-full-dnskey').click(function() {
        var $textarea = $('#full-dnskey-content');
        $textarea.select();
        
        try {
            var successful = document.execCommand('copy');
            if (successful) {
                var $btn = $(this);
                var originalHtml = $btn.html();
                $btn.html('<i class="fas fa-check"></i>').addClass('btn-success').removeClass('btn-default');
                
                setTimeout(function() {
                    $btn.html(originalHtml).removeClass('btn-success').addClass('btn-default');
                }, 2000);
            } else {
                alert('Copy failed. Please manually select and copy the DNSKEY record.');
            }
        } catch (err) {
            alert('Please manually select and copy the DNSKEY record.');
        }
    });
    
    // Import Zone functionality
    $('#importZoneForm').on('submit', function(e) {
        e.preventDefault();
        
        // Clear previous validation errors
        $('#import-validation-error').remove();
        
        var $form = $(this);
        var $btn = $('#import-zone-btn');
        var $modal = $('#importZoneModal');
        var originalBtnText = $btn.html();
        
        // Validate zone content
        var zoneContent = $('#zone-content').val().trim();
        if (!zoneContent) {
            $modal.find('.modal-body').prepend('<div id="import-validation-error" class="alert alert-danger"><i class="fas fa-exclamation-triangle"></i> Zone content cannot be empty.</div>');
            return false;
        }
        
        // Show loading state
        $btn.prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Importing...');
        
        // Submit form via AJAX
        $.ajax({
            url: $form.attr('action'),
            type: 'POST',
            data: $form.serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    // Show success message and reload page
                    $modal.modal('hide');
                    location.reload();
                } else {
                    // Show error message
                    $modal.find('.modal-body').prepend('<div id="import-validation-error" class="alert alert-danger"><i class="fas fa-exclamation-triangle"></i> ' + (response.error || 'Import failed. Please check your zone file format.') + '</div>');
                }
            },
            error: function() {
                $modal.find('.modal-body').prepend('<div id="import-validation-error" class="alert alert-danger"><i class="fas fa-exclamation-triangle"></i> Communication error during import. Please try again.</div>');
            },
            complete: function() {
                $btn.prop('disabled', false).html(originalBtnText);
            }
        });
    });
    
    // Clear import validation errors when modal is opened
    $('#importZoneModal').on('show.bs.modal', function() {
        $('#import-validation-error').remove();
        $('#zone-content').val('');
    });
});
</script>
