<?php
// modules/addons/powerdns_manager/lang/english.php

if (!defined("WHMCS")) {
    die("This file cannot be accessed directly");
}

$_ADDONLANG['title'] = "DNS Manager";
$_ADDONLANG['description'] = "Manage your domain name DNS records";
$_ADDONLANG['no_access'] = "You do not have permission to access this page";
$_ADDONLANG['error'] = "Error";
$_ADDONLANG['zone_not_found'] = "DNS zone not found";
$_ADDONLANG['no_zones'] = "You don't have any DNS zones available for management";
$_ADDONLANG['manage_records'] = "Manage Records";
$_ADDONLANG['back_to_zones'] = "Back to Zones";
$_ADDONLANG['domain'] = "Domain";
$_ADDONLANG['service'] = "Service";
$_ADDONLANG['created'] = "Created";
$_ADDONLANG['actions'] = "Actions";
$_ADDONLANG['name'] = "Name";
$_ADDONLANG['type'] = "Type";
$_ADDONLANG['content'] = "Content";
$_ADDONLANG['ttl'] = "TTL";
$_ADDONLANG['add_record'] = "Add Record";
$_ADDONLANG['edit_record'] = "Edit Record";
$_ADDONLANG['delete_record'] = "Delete";
$_ADDONLANG['delete_confirm'] = "Are you sure you want to delete this record?";
$_ADDONLANG['record_added'] = "Record added successfully";
$_ADDONLANG['record_updated'] = "Record updated successfully";
$_ADDONLANG['record_deleted'] = "Record deleted successfully";
$_ADDONLANG['filter_records'] = "Filter Records";
$_ADDONLANG['all'] = "All";
$_ADDONLANG['use_at_symbol'] = "Use @ for the zone apex";
$_ADDONLANG['a_record_hint'] = "192.168.0.1";
$_ADDONLANG['aaaa_record_hint'] = "2001:db8::1";
$_ADDONLANG['cname_record_hint'] = "example.com.";
$_ADDONLANG['mx_record_hint'] = "10 mail.example.com.";
$_ADDONLANG['txt_record_hint'] = "v=spf1 ip4:192.168.0.1 ~all";
$_ADDONLANG['srv_record_hint'] = "Priority Weight Port Target (e.g., 0 5 5060 sip.example.com.)";
$_ADDONLANG['ns_record_hint'] = "ns1.example.com.";
$_ADDONLANG['caa_record_hint'] = "0 issue \"letsencrypt.org\"";
$_ADDONLANG['tlsa_record_hint'] = "3 1 1 1234567890abcdef... (DANE for SSL/TLS)";
$_ADDONLANG['save_changes'] = "Save Changes";
$_ADDONLANG['cancel'] = "Cancel";
$_ADDONLANG['edit'] = "Edit";
$_ADDONLANG['unknown'] = "Unknown";
$_ADDONLANG['select_zone'] = "Select a zone below to manage its DNS records.";
$_ADDONLANG['nameservers_title'] = "Default Nameservers";
$_ADDONLANG['nameservers_info'] = "Your zones are using the following nameservers:";
$_ADDONLANG['nameservers_note'] = "If you're using other nameservers for a specific domain, please update the nameservers in the domain registrar to continue.";
$_ADDONLANG['records_propagation'] = "DNS changes may take up to 48 hours to propagate worldwide.";
$_ADDONLANG['zone_apex'] = "Zone Apex";
$_ADDONLANG['no_records'] = "No records found for this zone.";
$_ADDONLANG['search_records'] = "Search records...";
$_ADDONLANG['no_dns_zones'] = "No DNS zones found";
$_ADDONLANG['no_matching_zones'] = "No matching zones found";
$_ADDONLANG['show_records'] = "Show _MENU_ records";
$_ADDONLANG['search_zones'] = "Search zones...";
$_ADDONLANG['default_ns_protected'] = "Default nameservers are protected and cannot be modified";
$_ADDONLANG['export_zone'] = "Export Zone";
$_ADDONLANG['nameservers_match'] = 'Nameservers match expected configuration';
$_ADDONLANG['nameservers_mismatch'] = 'Nameservers do not match expected configuration';

// Tooltip language strings
$_ADDONLANG['name_tooltip'] = "The name of the record relative to the zone. Use @ for the zone apex (root domain). For subdomains, just enter the subdomain part (e.g. 'www' for www.example.com).";
$_ADDONLANG['type_tooltip'] = "<strong>A</strong>: Maps hostname to IPv4 address<br><strong>AAAA</strong>: Maps to IPv6 address<br><strong>CNAME</strong>: Creates alias to another domain<br><strong>MX</strong>: Directs mail to mail servers<br><strong>TXT</strong>: Stores text data<br><strong>SRV</strong>: Service location records<br><strong>CAA</strong>: Certificate Authority Authorization<br><strong>TLSA</strong>: DANE SSL/TLS certificate association";
$_ADDONLANG['content_tooltip'] = "<strong>A</strong>: IPv4 address (192.168.0.1)<br><strong>AAAA</strong>: IPv6 address (2001:db8::1)<br><strong>CNAME</strong>: Target domain with dot (example.com.)<br><strong>MX</strong>: Priority and mail server (10 mail.example.com.)<br><strong>SRV</strong>: Priority Weight Port Target (0 5 5060 sip.example.com.)<br><strong>TXT</strong>: Text content for SPF, DKIM, etc.<br><strong>TLSA</strong>: Usage Selector MatchingType CertData (3 1 1 1a2b3c...)";
$_ADDONLANG['ttl_tooltip'] = "Time To Live in seconds - how long DNS resolvers cache this record.<br><strong>3600</strong>: 1 hour (standard)<br><strong>86400</strong>: 1 day<br><strong>300</strong>: 5 minutes (for testing)<br>Lower values propagate faster but increase DNS traffic.";
$_ADDONLANG['srv_tooltip'] = "Service Record - Defines service location";

// Nameserver check strings
$_ADDONLANG['check_nameservers'] = 'Check NS';
$_ADDONLANG['nameserver_check_results'] = 'Nameserver Check Results';
$_ADDONLANG['checking_nameservers'] = 'Checking nameservers...';
$_ADDONLANG['expected_nameservers'] = 'Expected Nameservers';
$_ADDONLANG['actual_nameservers'] = 'Actual Nameservers';
$_ADDONLANG['close'] = 'Close';
$_ADDONLANG['via_google_dns'] = 'via Google DNS (8.8.8.8)';
$_ADDONLANG['via_cloudflare_dns'] = 'via Cloudflare (1.1.1.1)';

// Button tooltips
$_ADDONLANG['check_nameservers_tooltip'] = 'Check if nameservers are properly configured';
$_ADDONLANG['export_zone_tooltip'] = 'Export zone as text file';
$_ADDONLANG['ns_status'] = 'NS Status';
$_ADDONLANG['ns_status_click_to_check'] = 'Click to check nameservers';
$_ADDONLANG['ns_status_checking'] = 'Checking nameservers...';
$_ADDONLANG['ns_status_rechecking'] = 'Re-checking nameservers...';
$_ADDONLANG['ns_status_correct'] = 'Nameservers are correctly configured';
$_ADDONLANG['ns_status_incorrect'] = 'Nameservers are not correctly configured';
$_ADDONLANG['ns_status_error'] = 'Error checking nameservers';
$_ADDONLANG['ns_expected'] = 'Expected';
$_ADDONLANG['ns_actual'] = 'Actual';
$_ADDONLANG['dns_zone'] = 'DNS Zone';

// DNSSEC language strings
$_ADDONLANG['dnssec_management'] = 'DNSSEC Management';
$_ADDONLANG['dnssec_status'] = 'DNSSEC Status';
$_ADDONLANG['dnssec_enabled'] = 'Enabled';
$_ADDONLANG['dnssec_disabled'] = 'Disabled';
$_ADDONLANG['enable_dnssec'] = 'Enable DNSSEC';
$_ADDONLANG['disable_dnssec'] = 'Disable DNSSEC';
$_ADDONLANG['validate_dnssec'] = 'Validate DNSSEC';
$_ADDONLANG['last_validated'] = 'Last Validated';
$_ADDONLANG['never_validated'] = 'Never';
$_ADDONLANG['validation_valid'] = 'Valid';
$_ADDONLANG['validation_invalid'] = 'Invalid';
$_ADDONLANG['validation_error'] = 'Error';
$_ADDONLANG['validation_pending'] = 'Pending';
$_ADDONLANG['ds_records'] = 'DS Records';
$_ADDONLANG['ds_record'] = 'DS Record';
$_ADDONLANG['ds_records_help'] = 'Some registrars prefer DS records instead of raw keys. Use these if your registrar asks for DS records.';
$_ADDONLANG['ds_records_loading'] = 'DS records are being generated. Please refresh the page in a few moments.';
$_ADDONLANG['dnssec_records'] = 'DNSSEC Records';
$_ADDONLANG['no_dnssec_records'] = 'No DNSSEC records found. Records may still be generating.';
$_ADDONLANG['copy_to_clipboard'] = 'Copy to clipboard';
$_ADDONLANG['confirm_enable_dnssec'] = 'Are you sure you want to enable DNSSEC? This will generate cryptographic keys for your domain.';
$_ADDONLANG['confirm_disable_dnssec'] = 'Are you sure you want to disable DNSSEC? This will remove all DNSSEC records and keys.';
$_ADDONLANG['registrar_keys'] = 'Keys for Registrar';
$_ADDONLANG['registrar_keys_help'] = '<strong>Copy to registrar:</strong> Some registrars want key data (Flags, Algorithm, Public Key) from the table. Others prefer DS records (below).';
$_ADDONLANG['key_type'] = 'Key Type';
$_ADDONLANG['flags'] = 'Flags';
$_ADDONLANG['algorithm'] = 'Algorithm';
$_ADDONLANG['public_key'] = 'Public Key';
$_ADDONLANG['key_tag'] = 'Key Tag';
$_ADDONLANG['full_dnskey'] = 'Full';
$_ADDONLANG['full_dnskey_record'] = 'Full DNSKEY Record';
$_ADDONLANG['public_key_not_found'] = '⚠️ Public key not found - DNSSEC may still be generating';
$_ADDONLANG['ds_records_help'] = 'Some registrars prefer DS records instead of raw keys. Use these if your registrar asks for DS records.';
$_ADDONLANG['recommended'] = 'RECOMMENDED';
$_ADDONLANG['sha1_legacy'] = 'SHA-1 (legacy)';
$_ADDONLANG['sha256_recommended'] = 'SHA-256 (recommended)';
$_ADDONLANG['sha384_secure'] = 'SHA-384 (secure)';
$_ADDONLANG['full_dnskey_help'] = 'This is the complete DNSKEY record format. Some registrars may accept this format directly.';
$_ADDONLANG['enabled'] = 'Enabled';
$_ADDONLANG['last_validated_label'] = 'Last Validated:';
$_ADDONLANG['valid'] = 'Valid';
$_ADDONLANG['registrar_keys_loading'] = 'DNSSEC keys are being generated. Please refresh the page in a few moments.';
$_ADDONLANG['alternative_format'] = 'Alternative format';

// Import Zone strings
$_ADDONLANG['import_zone'] = 'Import Zone';
$_ADDONLANG['import_zone_help'] = 'Paste your zone file content below. Supports standard DNS zone file format with A, AAAA, CNAME, MX, TXT, SRV, NS, CAA, and TLSA records.';
$_ADDONLANG['zone_content'] = 'Zone File Content';
$_ADDONLANG['zone_content_tooltip'] = 'Standard zone file format. Examples:<br>@ A 192.168.1.1<br>www A 192.168.1.1<br>mail MX 10 mail.example.com.';
$_ADDONLANG['zone_content_placeholder'] = 'Paste your zone file content here...

Example:
@ 3600 IN A 192.168.1.1
www 3600 IN A 192.168.1.1
mail 3600 IN MX 10 mail.example.com.
@ 3600 IN TXT "v=spf1 mx -all"';
$_ADDONLANG['zone_content_help'] = 'Use @ for the zone apex (root domain). Relative names will be converted automatically.';
$_ADDONLANG['import_options'] = 'Import Options';
$_ADDONLANG['import_mode_merge'] = 'Merge with existing';
$_ADDONLANG['import_mode_merge_desc'] = 'Skip records that already exist, add new ones';
$_ADDONLANG['import_mode_replace'] = 'Replace all records';
$_ADDONLANG['import_mode_replace_desc'] = 'Delete existing records (except SOA) and add imported ones';
$_ADDONLANG['import_mode_append'] = 'Append all records';
$_ADDONLANG['import_mode_append_desc'] = 'Add all records even if duplicates exist';
$_ADDONLANG['preserve_soa'] = 'Preserve existing SOA record';
$_ADDONLANG['preserve_soa_help'] = 'Recommended to avoid DNS issues';