# PowerDNS Manager for WHMCS

WHMCS module for PowerDNS API integration. Manages DNS zones and records for domains and hosting products.

## Features

### Automation
* Creates zones on domain registration or DNS hosting activation
* Deletes zones on termination
* Associates existing zones on domain transfer
* Retry logic for failed operations

### Record Management
* A, AAAA, CNAME, MX, TXT, SRV, CAA, NS, TLSA
* SOA serial auto-increment
* Protected default nameservers
* Zone import (merge/replace/append)
* DNSSEC with key management and DS records

### Interface
* Admin and client areas
* 8 languages included
* Responsive design
* Activity logging

## Requirements

* WHMCS 8.9+
* PowerDNS 4.x with API enabled
* PHP 7.4+ with curl
* For DNSSEC: `gmysql-dnssec=yes` in `/etc/powerdns/pdns.conf`
* Valid license from ArkHost

## Installation

1. Upload `modules` folder to WHMCS root
2. Activate in Setup → Addon Modules
3. Configure API settings
4. Set admin permissions

## Configuration

### Module Settings
* **API URL**: PowerDNS API endpoint (e.g., `http://localhost:8081/api/v1`)
* **API Key**: PowerDNS API key
* **Server Name**: PowerDNS server identifier (default: `localhost`)
* **Zone Type**: Choose between `Native` (default) or `Master` for new zones
* **Nameservers**: NS1-NS5 for new zones (NS3-NS5 optional)
* **Default TTL**: TTL for new records (default: 3600)

## Usage

### Admin
* Manage all zones and records
* Import/export zones
* DNSSEC management
* Bulk operations

### Client
* Manage own zones
* Add/edit/delete records
* Import/export zones
* View DNSSEC status

### DNS Hosting Product
1. Create product in WHMCS
2. Select powerdns_manager module
3. Zones auto-create on order

## Automation Hooks

| Hook | Action |
|------|--------|
| AfterRegistrarRegistration | Create zone |
| AfterRegistrarTransfer | Associate/create zone |
| DomainDelete | Remove zone |
| AfterModuleTerminate | Clean associations |

## Files

```
modules/
├─ addons/powerdns_manager/
│  ├─ powerdns_manager.php
│  ├─ hooks.php
│  ├─ lib/
│  ├─ templates/
│  └─ lang/
└─ servers/powerdns_manager/
```

## Changelog

### v1.9
- Zone type configuration (Native/Master)
- Fixed NS record handling to prevent duplicates
- Uses rrsets approach (PowerDNS best practice)
- Improved zone creation compatibility

### v1.8
- Added zone ownership validation
- Protected domains list (admin configurable)
- Improved auto-association logic
- Enhanced activity logging

### v1.7
- DNSSEC support with key management
- Zone import with validation
- Real-time DNSSEC status
- Fixed TXT record parsing for long DKIM keys
- Added TLSA tooltips
- See [setup guide](https://arkhost.com/knowledgebase/5382/PowerDNS-Master-Slave-Configuration-with-DNSSEC-Support.html)

### v1.6
- 4th/5th nameserver support
- TTL edit fix
- TLSA record type
- Updated color scheme

### v1.5
- SOA read-only protection
- Default NS protection
- SRV record UI improvements

### v1.4
- Zone creation button
- Reduced logging
- Bug fixes

### v1.3
- Transfer status handling
- DataTables sorting

### v1.2
- Nameserver checking
- NS protection
- 7 languages
- Responsive design

### v1.1
- Multi-value editing
- Zone export
- UI improvements

### v1.0
- Initial release

## License

Requires valid license from [arkhost.com](https://arkhost.com)

## Support

[arkhost.com/submitticket.php](https://arkhost.com/submitticket.php)

---
© ArkHost