/*
 * Decompiled with CFR 0.152.
 */
package live.thought.jtminer.stratum;

import live.thought.jtminer.StratumMiner;
import live.thought.jtminer.algo.CuckooSolve;
import live.thought.jtminer.algo.SHA256d;
import live.thought.jtminer.stratum.StratumClient;
import live.thought.jtminer.stratum.StratumException;
import live.thought.jtminer.stratum.StratumWork;
import live.thought.jtminer.util.Console;

public class StratumSolver
implements Runnable {
    private final int index;
    private CuckooSolve solve;
    private final StratumClient client;
    private volatile StratumWork currentWork;
    private final StratumMiner miner;
    private final SHA256d hasher = new SHA256d(32);
    private volatile boolean interrupted = false;
    private volatile boolean stopped = false;
    private Thread runningThread;
    private final int[] us;
    private final int[] vs;
    private final StringBuilder solutionBuilder;

    public StratumSolver(StratumClient client, StratumWork work, int index, CuckooSolve solve, StratumMiner miner) {
        this.solve = solve;
        this.index = index;
        this.currentWork = work;
        this.client = client;
        this.miner = miner;
        this.us = new int[4096];
        this.vs = new int[4096];
        this.solutionBuilder = new StringBuilder(336);
    }

    public void stop() {
        this.interrupted = true;
        if (this.runningThread != null) {
            this.runningThread.interrupt();
        }
    }

    public void forceStop() {
        this.interrupted = true;
        if (this.runningThread != null) {
            this.runningThread.interrupt();
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    private void cleanup() {
        if (this.solve != null) {
            this.solve.cleanup();
            this.solve = null;
        }
        if (this.hasher != null) {
            this.hasher.cleanup();
        }
        this.runningThread = null;
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.runningThread = Thread.currentThread();
        cuckoo = this.solve.getCuckoo();
        try {
            try {
                threadIndex = this.index;
                threadCount = this.solve.getNthreads();
                maxNonce = this.solve.getEasiness();
                graph = this.solve.getGraph();
                nonce = threadIndex;
                if (true) ** GOTO lbl81
                do {
                    block18: {
                        block20: {
                            block19: {
                                if (Thread.currentThread().isInterrupted()) {
                                    this.interrupted = true;
                                    return;
                                }
                                u0 = graph.sipnode(nonce, 0);
                                v0 = graph.sipnode(nonce, 1) + 0x800000;
                                this.us[0] = u0;
                                this.vs[0] = v0;
                                u = cuckoo[u0];
                                v = cuckoo[v0];
                                if (u == v0 || v == u0) break block18;
                                nu = this.solve.path(u, this.us);
                                if (this.us[nu] != this.vs[nv = this.solve.path(v, this.vs)]) break block19;
                                if (Thread.currentThread().isInterrupted()) {
                                    this.interrupted = true;
                                    return;
                                }
                                min = nu < nv ? nu : nv;
                                nu -= min;
                                nv -= min;
                                while (this.us[nu] != this.vs[nv]) {
                                    ++nu;
                                    ++nv;
                                }
                                len = nu + nv + 1;
                                this.miner.cycleCount.incrementAndGet();
                                if (len == 42 && (soln = this.solve.solution(this.us, nu, this.vs, nv)) != null) {
                                    this.miner.solutionCount.incrementAndGet();
                                    if (graph.verify(soln, 0x1000000).booleanValue()) {
                                        try {
                                            if (!this.currentWork.meetsTarget(soln)) break block18;
                                            Console.debug("Trying to submit solution", 2);
                                            this.solutionBuilder.setLength(0);
                                            var19_21 = soln;
                                            var18_20 = soln.length;
                                            var17_19 = 0;
                                            while (var17_19 < var18_20) {
                                                n = var19_21[var17_19];
                                                this.solutionBuilder.append(n).append(',');
                                                ++var17_19;
                                            }
                                            if (this.solutionBuilder.length() > 0) {
                                                this.solutionBuilder.setLength(this.solutionBuilder.length() - 1);
                                            }
                                            this.client.submitWork(this.currentWork, this.solutionBuilder.toString());
                                            break block18;
                                        }
                                        catch (StratumException e) {
                                            Console.debug("Error submitting solution: " + e.getMessage(), 2);
                                            return;
                                        }
                                    }
                                    this.miner.errorCount.incrementAndGet();
                                }
                                break block18;
                            }
                            if (nu >= nv) ** GOTO lbl73
                            while (nu-- != 0) {
                                cuckoo[this.us[nu + 1]] = this.us[nu];
                            }
                            cuckoo[this.us[0]] = this.vs[0];
                            break block20;
lbl-1000:
                            // 1 sources

                            {
                                cuckoo[this.vs[nv + 1]] = this.vs[nv];
lbl73:
                                // 2 sources

                                ** while (nv-- != 0)
                            }
lbl74:
                            // 1 sources

                            cuckoo[this.vs[0]] = this.us[0];
                        }
                        if (nonce % 100 == 0 && Thread.currentThread().isInterrupted()) {
                            this.interrupted = true;
                            return;
                        }
                    }
                    nonce += threadCount;
lbl81:
                    // 2 sources

                    if (this.interrupted) return;
                } while (nonce < maxNonce);
                return;
            }
            catch (RuntimeException re) {
                Console.debug("Illegal cycle detected", 2);
                this.cleanup();
                Console.debug("Solver " + this.index + " stopped", 2);
            }
            return;
        }
        finally {
            this.cleanup();
            Console.debug("Solver " + this.index + " stopped", 2);
        }
    }
}

