/*
 * Decompiled with CFR 0.152.
 */
package live.thought.jtminer.stratum;

import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import live.thought.jtminer.stratum.StratumClient;
import live.thought.jtminer.util.Console;

public class ConnectionMonitor {
    private static final long MAX_NOTIFICATION_GAP_SECONDS = 60L;
    private static final long CHECK_INTERVAL_SECONDS = 5L;
    private static final int MAX_TIMEOUT_ALERTS = 2;
    private final StratumClient client;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> monitorTask;
    private final AtomicLong lastNotificationTime;
    private final AtomicBoolean isRunning;
    private final AtomicInteger timeoutAlertCount = new AtomicInteger(0);

    public ConnectionMonitor(StratumClient client) {
        this.client = client;
        this.scheduler = this.createScheduler();
        this.lastNotificationTime = new AtomicLong(System.currentTimeMillis());
        this.isRunning = new AtomicBoolean(false);
    }

    private ScheduledExecutorService createScheduler() {
        return Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "Connection-Monitor");
            t.setDaemon(true);
            return t;
        });
    }

    private void ensureValidScheduler() {
        if (this.scheduler == null || this.scheduler.isShutdown() || this.scheduler.isTerminated()) {
            if (this.scheduler != null) {
                try {
                    this.scheduler.shutdownNow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.scheduler = this.createScheduler();
            Console.debug("Created new scheduler for connection monitor", 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.isRunning.compareAndSet(false, true)) {
            this.timeoutAlertCount.set(0);
            this.lastNotificationTime.set(System.currentTimeMillis());
            this.ensureValidScheduler();
            ConnectionMonitor connectionMonitor = this;
            synchronized (connectionMonitor) {
                if (this.monitorTask != null) {
                    this.monitorTask.cancel(false);
                    this.monitorTask = null;
                }
                try {
                    this.monitorTask = this.scheduler.scheduleAtFixedRate(this::checkConnection, 5L, 5L, TimeUnit.SECONDS);
                    Console.debug("Connection monitor task scheduled successfully", 2);
                }
                catch (RejectedExecutionException e) {
                    Console.output("Failed to schedule connection monitor: " + e.getMessage() + ". Recreating scheduler.");
                    this.ensureValidScheduler();
                    try {
                        this.monitorTask = this.scheduler.scheduleAtFixedRate(this::checkConnection, 5L, 5L, TimeUnit.SECONDS);
                        Console.debug("Connection monitor task scheduled after recreation", 2);
                    }
                    catch (Exception e2) {
                        Console.output("Critical error scheduling connection monitor: " + e2.getMessage());
                        this.isRunning.set(false);
                        return;
                    }
                }
            }
            Console.debug("Connection monitor started", 2);
        } else {
            this.lastNotificationTime.set(System.currentTimeMillis());
            this.timeoutAlertCount.set(0);
            Console.debug("Connection monitor already running, timestamp reset", 2);
        }
    }

    private void checkConnection() {
        block10: {
            try {
                long lastNotif;
                if (!this.client.isConnected()) {
                    Console.debug("Connection already marked as disconnected", 2);
                    return;
                }
                long currentTime = System.currentTimeMillis();
                long timeSinceLastNotification = currentTime - (lastNotif = this.lastNotificationTime.get());
                if (timeSinceLastNotification > TimeUnit.SECONDS.toMillis(60L)) {
                    int alerts = this.timeoutAlertCount.incrementAndGet();
                    Console.output("No mining notifications received in " + String.format("%.1f", (double)timeSinceLastNotification / 1000.0 / 60.0) + " minutes (alert #" + alerts + ")");
                    try {
                        boolean pingResult = this.client.ping();
                        if (!pingResult) {
                            Console.output("Ping test failed, connection appears to be lost");
                            this.handleConnectionLost();
                            return;
                        }
                        Console.debug("Ping test successful but no mining notifications received", 2);
                    }
                    catch (Exception e) {
                        Console.output("Ping test threw exception: " + e.getMessage());
                        this.handleConnectionLost();
                        return;
                    }
                    if (timeSinceLastNotification > TimeUnit.SECONDS.toMillis(180L)) {
                        Console.output("Long period without communication (" + String.format("%.1f", (double)timeSinceLastNotification / 1000.0 / 60.0) + " minutes), forcing reconnection");
                        this.handleConnectionLost();
                        return;
                    }
                    if (alerts >= 2) {
                        Console.output("Connection appears stale after " + String.format("%.1f", (double)(60L * (long)alerts) / 60.0) + " minutes with no activity. Forcing reconnection.");
                        this.handleConnectionLost();
                    }
                    break block10;
                }
                if (this.timeoutAlertCount.get() > 0) {
                    this.timeoutAlertCount.set(0);
                    Console.debug("Connection is active, alert count reset", 2);
                }
            }
            catch (Exception e) {
                Console.debug("Error in connection check: " + e.getMessage(), 2);
            }
        }
    }

    private void handleConnectionLost() {
        this.client.handleConnectionTimeout();
        this.timeoutAlertCount.set(0);
    }

    public void notificationReceived() {
        this.lastNotificationTime.set(System.currentTimeMillis());
        this.timeoutAlertCount.set(0);
        Console.debug("Mining notification received, connection alive", 2);
    }

    public void forceCheck() {
        Console.debug("Forcing connection check", 2);
        if (this.isRunning.get()) {
            try {
                this.checkConnection();
            }
            catch (Exception e) {
                Console.debug("Error during forced connection check: " + e.getMessage(), 2);
            }
        } else {
            Console.debug("Cannot force check - connection monitor not running", 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.isRunning.compareAndSet(true, false)) {
            ConnectionMonitor connectionMonitor = this;
            synchronized (connectionMonitor) {
                if (this.monitorTask != null) {
                    this.monitorTask.cancel(true);
                    this.monitorTask = null;
                }
                Console.debug("Connection monitor task cancelled", 2);
            }
            Console.debug("Connection monitor stopped", 2);
        }
    }
}

