/*
 * Decompiled with CFR 0.152.
 */
package live.thought.jtminer.stratum;

import java.math.BigInteger;
import live.thought.jtminer.data.DataUtils;

public final class TargetUtils {
    private static final String MAX_TARGET_HEX = "FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF";
    private static final BigInteger MAX_TARGET = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF", 16);
    private static final BigInteger FACTOR = BigInteger.valueOf(10000L);
    private static final double MIN_DIFFICULTY = 1.0E-6;
    private static final int TARGET_SIZE = 32;
    private static final int CACHE_SIZE = 100;
    private static final DifficultyCache difficultyCache = new DifficultyCache(100);

    private TargetUtils() {
        throw new AssertionError((Object)"TargetUtils is a utility class and should not be instantiated");
    }

    public static byte[] diffToTarget(double diff) {
        TargetUtils.validateDifficulty(diff);
        byte[] cachedTarget = difficultyCache.get(diff);
        if (cachedTarget != null) {
            return (byte[])cachedTarget.clone();
        }
        byte[] target = TargetUtils.calculateTarget(Math.max(diff, 1.0E-6));
        difficultyCache.put(diff, target);
        return (byte[])target.clone();
    }

    private static byte[] calculateTarget(double diff) {
        BigInteger diffInt = BigInteger.valueOf((long)(diff * 10000.0));
        BigInteger currentTarget = MAX_TARGET.multiply(FACTOR).divide(diffInt);
        byte[] targetBytes = new byte[32];
        byte[] currentTargetBytes = currentTarget.toByteArray();
        int startPos = Math.max(0, 32 - currentTargetBytes.length);
        System.arraycopy(currentTargetBytes, 0, targetBytes, startPos, Math.min(currentTargetBytes.length, 32));
        return DataUtils.reverseBytes(targetBytes);
    }

    public static boolean checkTarget(byte[] hash, byte[] target) {
        TargetUtils.validateHashAndTarget(hash, target);
        for (int i = 31; i >= 0; --i) {
            int h = hash[i] & 0xFF;
            int t = target[i] & 0xFF;
            if (h == t) continue;
            return h < t;
        }
        return true;
    }

    public static double targetToDiff(byte[] target) {
        TargetUtils.validateTarget(target);
        BigInteger targetBigInt = new BigInteger(1, DataUtils.reverseBytes(target));
        if (targetBigInt.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException("Invalid target value");
        }
        BigInteger result = MAX_TARGET.multiply(FACTOR).divide(targetBigInt);
        return result.doubleValue() / 10000.0;
    }

    private static void validateDifficulty(double diff) {
        if (Double.isNaN(diff) || Double.isInfinite(diff) || diff <= 0.0) {
            throw new IllegalArgumentException("Invalid difficulty value: " + diff);
        }
    }

    private static void validateHashAndTarget(byte[] hash, byte[] target) {
        if (hash == null || target == null) {
            throw new IllegalArgumentException("Hash and target cannot be null");
        }
        if (hash.length != 32 || target.length != 32) {
            throw new IllegalArgumentException("Hash and target must be 32 bytes");
        }
    }

    private static void validateTarget(byte[] target) {
        if (target == null || target.length != 32) {
            throw new IllegalArgumentException("Target must be 32 bytes");
        }
    }

    public static String targetToHex(byte[] target) {
        TargetUtils.validateTarget(target);
        return DataUtils.byteArrayToHexString(DataUtils.reverseBytes(target));
    }

    private static class DifficultyCache {
        private final int capacity;
        private final CacheEntry[] entries;
        private int size;

        public DifficultyCache(int capacity) {
            this.capacity = capacity;
            this.entries = new CacheEntry[capacity];
            this.size = 0;
        }

        public synchronized byte[] get(double difficulty) {
            for (int i = 0; i < this.size; ++i) {
                if (this.entries[i].difficulty != difficulty) continue;
                return (byte[])this.entries[i].target.clone();
            }
            return null;
        }

        public synchronized void put(double difficulty, byte[] target) {
            for (int i = 0; i < this.size; ++i) {
                if (this.entries[i].difficulty != difficulty) continue;
                return;
            }
            if (this.size == this.capacity) {
                System.arraycopy(this.entries, 1, this.entries, 0, this.size - 1);
                --this.size;
            }
            this.entries[this.size++] = new CacheEntry(difficulty, target);
        }

        private static class CacheEntry {
            final double difficulty;
            final byte[] target;

            CacheEntry(double difficulty, byte[] target) {
                this.difficulty = difficulty;
                this.target = (byte[])target.clone();
            }
        }
    }
}

