/*
 * Decompiled with CFR 0.152.
 */
package live.thought.jtminer.stratum;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import live.thought.jtminer.algo.SHA256d;
import live.thought.jtminer.data.DataUtils;
import live.thought.jtminer.util.Console;
import org.json.JSONArray;

public final class StratumWork {
    private final String jobId;
    private final String prevHash;
    private final String coinbase1;
    private final String coinbase2;
    private final List<String> merkleBranch;
    private final String version;
    public String ntime;
    private final String nbits;
    private final boolean cleanJobs;
    private final ReentrantLock stateLock = new ReentrantLock();
    private final AtomicReference<byte[]> xnonce2;
    private volatile byte[] target;
    private volatile byte[] data;
    private String extraNonce1;
    private int extraNonce2Size;
    public int nonce;
    private final ReentrantLock cacheLock = new ReentrantLock();
    private byte[] cachedMerkleRoot;
    private static final int HEADER_SIZE = 80;
    private static final int VERSION_OFFSET = 0;
    private static final int PREV_HASH_OFFSET = 4;
    private static final int MERKLE_ROOT_OFFSET = 36;
    private static final int TIME_OFFSET = 68;
    private static final int BITS_OFFSET = 72;
    private static final int NONCE_OFFSET = 76;
    private static final int SOLUTION_LENGTH = 42;

    private StratumWork(Builder builder) {
        this.jobId = builder.jobId;
        this.prevHash = builder.prevHash;
        this.coinbase1 = builder.coinbase1;
        this.coinbase2 = builder.coinbase2;
        this.merkleBranch = new ArrayList<String>(builder.merkleBranch);
        this.version = builder.version;
        this.nbits = builder.nbits;
        this.ntime = builder.ntime;
        this.cleanJobs = builder.cleanJobs;
        this.xnonce2 = new AtomicReference();
        this.nonce = 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static StratumWork fromNotification(JSONArray params) {
        if (params == null || params.length() < 9) {
            throw new IllegalArgumentException("Invalid stratum notification parameters");
        }
        return StratumWork.builder().jobId(params.getString(0)).prevHash(params.getString(1)).coinbase1(params.getString(2)).coinbase2(params.getString(3)).merkleBranch(StratumWork.parseStringArray(params.getJSONArray(4))).version(params.getString(5)).nbits(params.getString(6)).ntime(params.getString(7)).cleanJobs(params.getBoolean(8)).build();
    }

    public void prepareWork(String extraNonce1, int extraNonce2Size) {
        if (extraNonce1 == null || extraNonce2Size <= 0) {
            throw new IllegalArgumentException("Invalid extra nonce parameters");
        }
        this.stateLock.lock();
        try {
            this.extraNonce1 = extraNonce1;
            this.extraNonce2Size = extraNonce2Size;
            this.xnonce2.set(new byte[extraNonce2Size]);
            this.invalidateCache();
            this.updateBlockHeader();
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public void updateBlockHeader() {
        byte[] merkleRoot = this.calculateMerkleRoot();
        byte[] newData = new byte[80];
        byte[] versionBytes = DataUtils.hexStringToByteArray(this.version);
        byte[] reversedVersion = DataUtils.reverseBytes(versionBytes);
        System.arraycopy(reversedVersion, 0, newData, 0, 4);
        byte[] prevHashBytes = DataUtils.hexStringToByteArray(this.prevHash);
        byte[] reversedPrevHash = DataUtils.reverseBytes(prevHashBytes);
        System.arraycopy(reversedPrevHash, 0, newData, 4, 32);
        System.arraycopy(merkleRoot, 0, newData, 36, 32);
        byte[] ntimeBytes = DataUtils.hexStringToByteArray(this.ntime);
        byte[] reversedNtime = DataUtils.reverseBytes(ntimeBytes);
        System.arraycopy(reversedNtime, 0, newData, 68, 4);
        byte[] nbitsBytes = DataUtils.hexStringToByteArray(this.nbits);
        byte[] reversedNbits = DataUtils.reverseBytes(nbitsBytes);
        System.arraycopy(reversedNbits, 0, newData, 72, 4);
        this.data = newData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] calculateMerkleRoot() {
        SHA256d hasher = new SHA256d(32);
        try {
            String coinbase = this.coinbase1 + this.extraNonce1 + DataUtils.byteArrayToHexString(this.xnonce2.get());
            if (coinbase.length() + this.coinbase2.length() > 0x7FFFFFFE) {
                throw new IllegalStateException("Coinbase transaction too large");
            }
            coinbase = coinbase + this.coinbase2;
            Console.debug("Coinbase : " + coinbase, 2);
            hasher.update(DataUtils.hexStringToByteArray(coinbase));
            byte[] merkleRoot = new byte[64];
            System.arraycopy(hasher.doubleDigest(), 0, merkleRoot, 0, 32);
            for (String h : this.merkleBranch) {
                System.arraycopy(DataUtils.hexStringToByteArray(h), 0, merkleRoot, 32, 32);
                hasher.update(merkleRoot);
                System.arraycopy(hasher.doubleDigest(), 0, merkleRoot, 0, 32);
            }
            byte[] finalMerkleRoot = new byte[32];
            System.arraycopy(merkleRoot, 0, finalMerkleRoot, 0, 32);
            Console.debug("FinalMerkle : " + DataUtils.byteArrayToHexString(finalMerkleRoot), 2);
            byte[] byArray = finalMerkleRoot;
            return byArray;
        }
        finally {
            hasher.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] incrementExtraNonce2() {
        this.stateLock.lock();
        try {
            byte[] current = this.xnonce2.get();
            byte[] next = (byte[])current.clone();
            for (int i = 0; i < next.length; ++i) {
                int n = i;
                next[n] = (byte)(next[n] + 1);
                if (next[i] != 0) break;
            }
            this.xnonce2.set(next);
            this.invalidateCache();
            this.updateBlockHeader();
            byte[] byArray = (byte[])next.clone();
            return byArray;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] randomizeExtraNonce2() {
        this.stateLock.lock();
        try {
            byte[] randomBytes = new byte[this.xnonce2.get().length];
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(randomBytes);
            this.xnonce2.set(randomBytes);
            this.invalidateCache();
            this.updateBlockHeader();
            byte[] byArray = (byte[])randomBytes.clone();
            return byArray;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public void updateNTime() {
        String hexTime;
        long currentTime = Long.parseLong(this.ntime, 16) + 1L;
        this.ntime = hexTime = String.format("%08x", currentTime);
        this.invalidateCache();
        this.updateBlockHeader();
    }

    private void invalidateCache() {
        this.cacheLock.lock();
        try {
            this.cachedMerkleRoot = null;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    public byte[] getHeader() {
        byte[] header = (byte[])this.data.clone();
        byte[] nonce = DataUtils.hexStringToByteArray(String.format("%08x", this.nonce));
        System.arraycopy(nonce, 0, header, 76, 4);
        Console.debug("Header data inside getheader " + DataUtils.byteArrayToHexString(header), 2);
        return header;
    }

    public boolean meetsTarget(int[] solution) {
        try {
            if (solution == null || solution.length != 42) {
                Console.debug("Arr\u00eat Solution", 2);
                return false;
            }
            byte[] targetCopy = this.target;
            if (targetCopy == null) {
                Console.debug("Arr\u00eat Target", 2);
                return false;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (int n : solution) {
                byte[] bytes = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
                baos.write(bytes);
            }
            SHA256d hasher = new SHA256d(32);
            hasher.update(baos.toByteArray());
            byte[] hash = hasher.doubleDigest();
            BigInteger hashValue = new BigInteger(1, DataUtils.reverseBytes(hash));
            if (hashValue.compareTo(BigInteger.ZERO) < 0) {
                return false;
            }
            BigInteger targetValue = new BigInteger(1, DataUtils.reverseBytes(targetCopy));
            BigInteger truediffone = new BigInteger("452312848583266388373324160190187140051835877600158453279131187530910662656");
            double diff = truediffone.doubleValue() / hashValue.doubleValue();
            Console.debug("Share Difficulty : " + diff, 2);
            return hashValue.compareTo(targetValue) <= 0;
        }
        catch (Exception e) {
            Console.debug("Error checking target: " + e.getMessage(), 2);
            return false;
        }
    }

    public void setTarget(byte[] newTarget) {
        if (newTarget == null || newTarget.length != 32) {
            throw new IllegalArgumentException("Invalid target");
        }
        this.target = (byte[])newTarget.clone();
        Console.debug("Target : " + DataUtils.byteArrayToHexString(this.target), 2);
    }

    private static List<String> parseStringArray(JSONArray array) {
        if (array == null) {
            throw new IllegalArgumentException("Array cannot be null");
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < array.length(); ++i) {
            result.add(array.getString(i));
        }
        return result;
    }

    public String getJobId() {
        return this.jobId;
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    public byte[] getTarget() {
        return this.target != null ? (byte[])this.target.clone() : null;
    }

    public byte[] getXnonce2() {
        return (byte[])this.xnonce2.get().clone();
    }

    public String getNtime() {
        return this.ntime;
    }

    public boolean isCleanJobs() {
        return this.cleanJobs;
    }

    public static class Builder {
        private String jobId;
        private String prevHash;
        private String coinbase1;
        private String coinbase2;
        private List<String> merkleBranch;
        private String version;
        private String nbits;
        private String ntime;
        private boolean cleanJobs;

        private Builder() {
        }

        public Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder prevHash(String prevHash) {
            this.prevHash = prevHash;
            return this;
        }

        public Builder coinbase1(String coinbase1) {
            this.coinbase1 = coinbase1;
            return this;
        }

        public Builder coinbase2(String coinbase2) {
            this.coinbase2 = coinbase2;
            return this;
        }

        public Builder merkleBranch(List<String> merkleBranch) {
            this.merkleBranch = merkleBranch;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder nbits(String nbits) {
            this.nbits = nbits;
            return this;
        }

        public Builder ntime(String ntime) {
            this.ntime = ntime;
            return this;
        }

        public Builder cleanJobs(boolean cleanJobs) {
            this.cleanJobs = cleanJobs;
            return this;
        }

        public StratumWork build() {
            this.validate();
            return new StratumWork(this);
        }

        private void validate() {
            if (this.jobId == null || this.prevHash == null || this.coinbase1 == null || this.coinbase2 == null || this.merkleBranch == null || this.version == null || this.nbits == null || this.ntime == null) {
                throw new IllegalStateException("All fields must be non-null");
            }
        }
    }
}

