/*
 * Decompiled with CFR 0.152.
 */
package live.thought.jtminer.stratum;

public class StratumException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final Type type;

    public StratumException(Type type, String message) {
        super(type.getDescription() + ": " + message);
        this.type = type;
    }

    public StratumException(Type type, String message, Throwable cause) {
        super(type.getDescription() + ": " + message, cause);
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isFatal() {
        return this.type == Type.CONNECTION_ERROR || this.type == Type.AUTHENTICATION_ERROR;
    }

    public static enum Type {
        CONNECTION_ERROR("Connection error"),
        AUTHENTICATION_ERROR("Authentication error"),
        PROTOCOL_ERROR("Protocol error"),
        MINING_ERROR("Mining error"),
        SUBMISSION_ERROR("Share submission error");

        private final String description;

        private Type(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

