/*
 * Decompiled with CFR 0.152.
 */
package live.thought.jtminer.stratum;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.Observable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import live.thought.jtminer.StratumMiner;
import live.thought.jtminer.data.DataUtils;
import live.thought.jtminer.stratum.ConnectionMonitor;
import live.thought.jtminer.stratum.ReconnectionHandler;
import live.thought.jtminer.stratum.StratumException;
import live.thought.jtminer.stratum.StratumNotification;
import live.thought.jtminer.stratum.StratumWork;
import live.thought.jtminer.stratum.TargetUtils;
import live.thought.jtminer.util.Console;
import live.thought.jtminer.util.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StratumClient
extends Observable {
    private final String url;
    private final int port;
    private final String username;
    private final String password;
    private final ReconnectionHandler reconnectionHandler;
    private final ConnectionMonitor connectionMonitor;
    private Socket socket;
    private BufferedReader reader;
    private PrintWriter writer;
    private volatile boolean connected;
    private volatile StratumWork currentWork;
    private final ReentrantLock workLock = new ReentrantLock();
    private volatile String extraNonce1;
    private volatile int extraNonce2Size;
    private volatile double diff;
    private final AtomicInteger nextId = new AtomicInteger(3);
    private final Object outputLock = new Object();
    private String VERSION = "v0.6.0";
    private StratumMiner.WorkHandler workHandler;

    public StratumClient(String url, int port, String username, String password) {
        if (url == null || username == null || password == null) {
            throw new IllegalArgumentException("URL, username and password cannot be null");
        }
        this.url = url;
        this.port = port;
        this.username = username;
        this.password = password;
        this.reconnectionHandler = new ReconnectionHandler(this);
        this.connectionMonitor = new ConnectionMonitor(this);
    }

    public void setWorkHandler(StratumMiner.WorkHandler handler) {
        this.workHandler = handler;
        if (this.reconnectionHandler != null) {
            this.reconnectionHandler.setWorkHandler(handler);
        }
    }

    public ReconnectionHandler getReconnectionHandler() {
        return this.reconnectionHandler;
    }

    private void resetMiningState() {
        this.workLock.lock();
        try {
            this.currentWork = null;
            this.extraNonce1 = null;
            this.extraNonce2Size = 0;
            this.diff = 0.0;
        }
        finally {
            this.workLock.unlock();
        }
    }

    public void connect() throws StratumException {
        this.resetMiningState();
        try {
            this.socket = new Socket(this.url, this.port);
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            this.writer = new PrintWriter((Writer)new OutputStreamWriter(this.socket.getOutputStream()), true);
            this.connected = true;
            Thread responseThread = new Thread(this::readResponses, "Stratum-Reader");
            responseThread.setDaemon(true);
            responseThread.start();
            this.subscribe();
            this.authorize();
            this.connectionMonitor.start();
        }
        catch (IOException e) {
            this.cleanup();
            throw new StratumException(StratumException.Type.CONNECTION_ERROR, "Failed to connect: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readResponses() {
        try {
            while (this.connected) {
                String line = this.reader.readLine();
                if (line == null) {
                    return;
                }
                try {
                    Console.debug(line, 2);
                    JSONObject response = new JSONObject(line);
                    this.handleResponse(response);
                }
                catch (JSONException e) {
                    Console.debug("Invalid JSON response: " + line, 2);
                }
            }
            return;
        }
        catch (IOException e) {
            if (!this.connected) return;
            Console.output("Connection lost: " + e.getMessage());
            this.connected = false;
            this.closeNetworkResources();
            this.notifyError(new StratumException(StratumException.Type.CONNECTION_ERROR, "Connection lost: " + e.getMessage()));
            if (this.reconnectionHandler != null) {
                this.reconnectionHandler.startReconnection();
                return;
            }
            Console.output("ERROR: ReconnectionHandler is null, cannot reconnect");
        }
    }

    private void closeNetworkResources() {
        try {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    Console.debug("Error closing socket: " + e.getMessage(), 2);
                }
            }
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    Console.debug("Error closing reader: " + e.getMessage(), 2);
                }
            }
            if (this.writer != null) {
                this.writer.close();
            }
            this.socket = null;
            this.reader = null;
            this.writer = null;
        }
        catch (Exception e) {
            Console.debug("Error in closeNetworkResources: " + e.getMessage(), 2);
        }
    }

    private void notifyReconnectionSuccess() {
        this.setChanged();
        this.notifyObservers(new StratumNotification(StratumNotification.Type.RECONNECTION_SUCCESS));
        Logger.log("Reconnection success notification sent");
    }

    private void handleResponse(JSONObject response) {
        block15: {
            try {
                if (response.has("method")) {
                    this.handleNotification(response);
                    break block15;
                }
                if (!response.has("id")) break block15;
                int idint = response.getInt("id");
                String id = response.get("id").toString();
                if (idint == 0) {
                    JSONObject errorObj = response.getJSONObject("error");
                    int errorCode = errorObj.getInt("code");
                    String errorMessage = errorObj.getString("message");
                    Console.output("Error: " + errorMessage + " (code: " + errorCode + ")");
                    Thread.sleep(30000L);
                    break block15;
                }
                if (response.has("result") && idint == 1) {
                    JSONArray result = response.getJSONArray("result");
                    if (result.length() < 3) break block15;
                    String newExtraNonce1 = result.getString(1);
                    int newExtraNonce2Size = result.getInt(2);
                    this.workLock.lock();
                    try {
                        this.extraNonce1 = newExtraNonce1;
                        this.extraNonce2Size = newExtraNonce2Size;
                        Console.debug("Got extranonce1: " + this.extraNonce1 + ", extranonce2_size: " + this.extraNonce2Size, 2);
                    }
                    finally {
                        this.workLock.unlock();
                    }
                    this.notifyReconnectionSuccess();
                    break block15;
                }
                if (idint == 2) {
                    String result = response.get("result").toString();
                    if (result.equals("true")) {
                        Console.debug("Worker authorized", 2);
                        this.notifyReconnectionSuccess();
                    } else {
                        Console.debug("Worker not authorized", 2);
                        this.disconnect();
                        this.reconnectionHandler.startReconnection();
                    }
                } else if (idint > 0) {
                    this.connectionMonitor.notificationReceived();
                    String result = response.get("result").toString();
                    if (result.equals("true")) {
                        this.workHandler.handleSubmitSuccess();
                    } else {
                        String error = response.get("error").toString();
                        this.workHandler.handleSubmitFailure(error);
                    }
                }
            }
            catch (Exception e) {
                Console.debug("Error handling response: " + e.getMessage(), 2);
            }
        }
    }

    private void handleNotification(JSONObject notification) {
        String method = notification.getString("method");
        JSONArray params = notification.getJSONArray("params");
        switch (method) {
            case "mining.notify": {
                this.connectionMonitor.notificationReceived();
                if (this.workHandler == null) break;
                StratumWork newWork = StratumWork.fromNotification(params);
                if (this.currentWork != null && newWork.getJobId().equals(this.currentWork.getJobId())) break;
                Logger.log("-----New job received from pool - Job ID: " + newWork.getJobId() + " (replacing job: " + (this.currentWork != null ? this.currentWork.getJobId() : "none") + ")");
                this.workHandler.stop();
                this.updateWork(newWork);
                this.currentWork.setTarget(TargetUtils.diffToTarget(this.diff));
                this.currentWork.nonce = 0;
                this.workHandler.handleNewWork(this.currentWork);
                break;
            }
            case "mining.set_difficulty": {
                double newDiff;
                this.connectionMonitor.notificationReceived();
                this.diff = newDiff = params.getDouble(0);
                this.workLock.lock();
                try {
                    if (this.currentWork != null) {
                        this.currentWork.setTarget(TargetUtils.diffToTarget(this.diff));
                    }
                }
                finally {
                    this.workLock.unlock();
                }
                Console.output("New diff: " + this.diff);
            }
        }
    }

    private void updateWork(StratumWork newWork) {
        this.workLock.lock();
        try {
            this.currentWork = null;
            this.currentWork = newWork;
            this.currentWork.prepareWork(this.extraNonce1, this.extraNonce2Size);
            Console.debug("Job : " + this.currentWork.getJobId(), 2);
        }
        finally {
            this.workLock.unlock();
        }
    }

    private void subscribe() throws StratumException {
        JSONObject request = new JSONObject().put("id", "1").put("method", "mining.subscribe").put("params", new JSONArray().put("jtminer/" + this.VERSION));
        this.sendRequest(request);
    }

    private void authorize() throws StratumException {
        JSONObject request = new JSONObject().put("id", "2").put("method", "mining.authorize").put("params", new JSONArray().put(this.username).put(this.password));
        this.sendRequest(request);
    }

    public void submitWork(StratumWork work, String solution) throws StratumException {
        if (!this.connected) {
            throw new StratumException(StratumException.Type.CONNECTION_ERROR, "Not connected to server");
        }
        JSONObject request = new JSONObject().put("id", this.getNextMessageId()).put("method", "mining.submit").put("params", new JSONArray().put(this.username).put(work.getJobId()).put(DataUtils.byteArrayToHexString(work.getXnonce2())).put(work.getNtime()).put(String.format("%08x", Integer.reverseBytes(work.nonce))).put(solution));
        this.sendRequest(request);
    }

    public void sendRequest(JSONObject request) {
        if (this.connected && this.writer != null) {
            this.writer.println(request.toString());
        }
    }

    private String getNextMessageId() {
        return String.valueOf(this.nextId.getAndIncrement());
    }

    private void notifyError(StratumException e) {
        this.setChanged();
        this.notifyObservers(new StratumNotification(StratumNotification.Type.ERROR, e.getMessage()));
    }

    public void disconnect() {
        if (!this.connected) {
            return;
        }
        this.connected = false;
        this.resetMiningState();
        this.closeNetworkResources();
        if (this.workHandler != null) {
            this.workHandler.stop();
        }
    }

    public boolean isReconnecting() {
        return this.reconnectionHandler != null && this.reconnectionHandler.isReconnecting();
    }

    public void cleanup() {
        this.deleteObservers();
        if (this.connectionMonitor != null) {
            this.connectionMonitor.stop();
        }
        this.disconnect();
        if (this.reconnectionHandler != null && !this.reconnectionHandler.isReconnecting()) {
            this.reconnectionHandler.stop();
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getExtraNonce1() {
        return this.extraNonce1;
    }

    public int getExtraNonce2Size() {
        return this.extraNonce2Size;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public StratumWork getCurrentWork() {
        this.workLock.lock();
        try {
            StratumWork stratumWork = this.currentWork;
            return stratumWork;
        }
        finally {
            this.workLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean ping() {
        if (!this.isConnected()) {
            return false;
        }
        try {
            JSONObject request = new JSONObject();
            request.put("id", this.nextId.getAndIncrement());
            request.put("method", "mining.subscribe");
            request.put("params", new JSONArray());
            Object object = this.outputLock;
            synchronized (object) {
                if (this.writer == null) return false;
                this.writer.write(request.toString());
                this.writer.write("\n");
                this.writer.flush();
                return true;
            }
        }
        catch (Exception e) {
            Console.debug("Ping failed: " + e.getMessage(), 2);
            return false;
        }
    }

    public ConnectionMonitor getConnectionMonitor() {
        return this.connectionMonitor;
    }

    public void handleConnectionTimeout() {
        this.setConnected(false);
        Console.output("Connection timeout detected. Initiating reconnection process.");
        try {
            this.closeNetworkResources();
        }
        catch (Exception e) {
            Console.debug("Error closing connection: " + e.getMessage(), 2);
        }
        if (this.reconnectionHandler != null) {
            this.reconnectionHandler.startReconnection();
        } else {
            Console.output("Error: Reconnection handler is null!");
        }
    }

    public void restartConnectionMonitor() {
        if (this.connectionMonitor != null) {
            this.connectionMonitor.stop();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.connectionMonitor.start();
            Console.debug("Connection monitor explicitly restarted after reconnection", 2);
        }
    }
}

