/*
 * Decompiled with CFR 0.152.
 */
package live.thought.jtminer.stratum;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import live.thought.jtminer.StratumMiner;
import live.thought.jtminer.stratum.ConnectionMonitor;
import live.thought.jtminer.stratum.StratumClient;
import live.thought.jtminer.stratum.StratumException;
import live.thought.jtminer.util.Console;

public class ReconnectionHandler {
    private static final int INITIAL_DELAY_SECONDS = 1;
    private static final int MAX_DELAY_SECONDS = 300;
    private static final double BACKOFF_MULTIPLIER = 1.5;
    private static final long STOP_TIMEOUT_MS = 5000L;
    private static final int MAX_CONSECUTIVE_FAILURES = 100;
    private final StratumClient client;
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> reconnectTask;
    private final AtomicBoolean isReconnecting = new AtomicBoolean(false);
    private final AtomicInteger attemptCount = new AtomicInteger(0);
    private final AtomicInteger failureCount = new AtomicInteger(0);
    private int currentDelay = 1;
    private StratumMiner.WorkHandler workHandler;
    private final Object executorLock = new Object();
    private final Object reconnectLock = new Object();

    public ReconnectionHandler(StratumClient client) {
        this.client = client;
        this.createExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createExecutor() {
        Object object = this.executorLock;
        synchronized (object) {
            this.cleanupExecutor();
            this.executor = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread t = new Thread(r, "Reconnection-Handler");
                t.setDaemon(true);
                return t;
            });
            Console.debug("Created new executor for reconnection handler", 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupExecutor() {
        Object object = this.executorLock;
        synchronized (object) {
            if (this.reconnectTask != null && !this.reconnectTask.isDone()) {
                this.reconnectTask.cancel(true);
                this.reconnectTask = null;
                Console.debug("Cancelled active reconnection task", 2);
            }
            if (this.executor != null && !this.executor.isShutdown()) {
                try {
                    Console.debug("Shutting down executor", 2);
                    this.executor.shutdownNow();
                    if (!this.executor.awaitTermination(2L, TimeUnit.SECONDS)) {
                        Console.debug("Executor did not terminate within timeout - resources may leak", 2);
                    } else {
                        Console.debug("Executor terminated successfully", 2);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    Console.debug("Interrupted while waiting for executor shutdown", 2);
                }
                catch (Exception e) {
                    Console.debug("Error shutting down executor: " + e.getMessage(), 2);
                }
            }
        }
    }

    public void setWorkHandler(StratumMiner.WorkHandler handler) {
        this.workHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReconnection() {
        Object object = this.reconnectLock;
        synchronized (object) {
            boolean wasAlreadyReconnecting = this.isReconnecting.getAndSet(true);
            if (wasAlreadyReconnecting) {
                Console.output("New disconnection detected while already reconnecting. Restarting reconnection process.");
                this.cleanupExecutor();
                this.failureCount.incrementAndGet();
            } else {
                this.attemptCount.set(0);
                this.failureCount.set(0);
                this.currentDelay = 1;
                Console.output("Starting reconnection process...");
            }
            try {
                if (this.workHandler != null) {
                    Console.output("Stopping all mining operations for reconnection...");
                    this.stopMiningOperations();
                }
                this.createExecutor();
                this.scheduleReconnection(0);
            }
            catch (Exception e) {
                Console.output("Error during reconnection setup: " + e.getMessage());
                this.createExecutor();
                this.scheduleReconnection(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleReconnection(int delaySeconds) {
        Object object = this.executorLock;
        synchronized (object) {
            if (!this.isReconnecting.get()) {
                Console.debug("Reconnection process stopped, cancelling scheduling", 2);
                return;
            }
            int delay = delaySeconds >= 0 ? delaySeconds : this.currentDelay;
            delay = Math.min(delay, 300);
            int currentAttempt = this.attemptCount.get() + 1;
            Console.output("Scheduling reconnection attempt in " + delay + " seconds (attempt #" + currentAttempt + ")");
            if (this.executor == null || this.executor.isShutdown()) {
                Console.debug("Executor invalid, creating new one", 2);
                this.createExecutor();
            }
            try {
                if (this.reconnectTask != null && !this.reconnectTask.isDone()) {
                    this.reconnectTask.cancel(false);
                }
                this.reconnectTask = this.executor.schedule(this::reconnect, (long)delay, TimeUnit.SECONDS);
                Console.debug("Reconnection scheduled successfully", 3);
            }
            catch (RejectedExecutionException e) {
                Console.output("Failed to schedule reconnection: " + e.getMessage());
                this.createExecutor();
                try {
                    this.reconnectTask = this.executor.schedule(this::reconnect, (long)delay, TimeUnit.SECONDS);
                    Console.debug("Reconnection scheduled after executor recreation", 2);
                }
                catch (Exception e2) {
                    Console.output("Critical error scheduling reconnection: " + e2.getMessage());
                    int finalDelay = delay;
                    Thread emergencyThread = new Thread(() -> {
                        try {
                            Thread.sleep(TimeUnit.SECONDS.toMillis(finalDelay));
                            this.reconnect();
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                    }, "Emergency-Reconnect");
                    emergencyThread.setDaemon(true);
                    emergencyThread.start();
                    Console.output("Using emergency reconnection thread due to executor failures");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect() {
        if (!this.isReconnecting.get()) {
            Console.debug("Reconnection cancelled before execution", 2);
            return;
        }
        int currentAttempt = this.attemptCount.incrementAndGet();
        if (currentAttempt % 500 == 0) {
            Console.output("Still attempting to reconnect after " + currentAttempt + " tries. Performing memory cleanup.");
            System.gc();
        }
        try {
            Console.output("Attempting to reconnect to mining pool... (attempt #" + currentAttempt + ")");
            this.client.connect();
            if (this.client.isConnected()) {
                Console.output("Successfully reconnected to mining pool after " + currentAttempt + " attempts");
                try {
                    ConnectionMonitor monitor = this.client.getConnectionMonitor();
                    if (monitor != null) {
                        monitor.stop();
                        Thread.sleep(100L);
                        monitor.start();
                        Console.output("Connection monitor explicitly restarted after reconnection");
                    }
                }
                catch (Exception e) {
                    Console.output("Warning: Error restarting connection monitor: " + e.getMessage());
                }
                Object e = this.reconnectLock;
                synchronized (e) {
                    this.isReconnecting.set(false);
                    this.attemptCount.set(0);
                    this.failureCount.set(0);
                    this.currentDelay = 1;
                }
                return;
            }
            this.failureCount.incrementAndGet();
            Console.output("Connection attempt #" + currentAttempt + " failed without exception");
        }
        catch (StratumException e) {
            this.failureCount.incrementAndGet();
            Console.output("Reconnection attempt #" + currentAttempt + " failed: " + e.getMessage());
        }
        catch (Exception e) {
            this.failureCount.incrementAndGet();
            Console.output("Unexpected error during reconnection attempt #" + currentAttempt + ": " + e.getMessage());
        }
        if (this.failureCount.get() > 100) {
            Console.output("Exceeded maximum reconnection failures (100). Will continue but may indicate a serious problem.");
            this.failureCount.set(50);
        }
        Object object = this.reconnectLock;
        synchronized (object) {
            if (this.isReconnecting.get()) {
                int actualMaxDelay = this.failureCount.get() > 10 ? Math.min(300, 60) : 300;
                this.currentDelay = (int)Math.min((double)this.currentDelay * 1.5, (double)actualMaxDelay);
                int jitter = (int)((double)this.currentDelay * 0.1);
                if (jitter > 0) {
                    this.currentDelay = Math.max(1, this.currentDelay - jitter + (int)(Math.random() * (double)jitter * 2.0));
                }
                Console.debug("Next reconnection attempt in " + this.currentDelay + " seconds", 2);
                this.scheduleReconnection(-1);
            }
        }
    }

    private void stopMiningOperations() {
        if (this.workHandler == null) {
            return;
        }
        CountDownLatch stopLatch = new CountDownLatch(1);
        Thread stopThread = new Thread(() -> {
            try {
                try {
                    this.workHandler.stop();
                }
                catch (Exception e) {
                    Console.debug("Error stopping mining operations: " + e.getMessage(), 2);
                    stopLatch.countDown();
                }
            }
            finally {
                stopLatch.countDown();
            }
        }, "Mining-Stop-Thread");
        stopThread.setDaemon(true);
        stopThread.start();
        try {
            if (!stopLatch.await(5000L, TimeUnit.MILLISECONDS)) {
                Console.output("Warning: Mining operations stop timeout - forcing shutdown");
                stopThread.interrupt();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Console.debug("Interrupted while stopping mining operations", 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.reconnectLock;
        synchronized (object) {
            this.isReconnecting.set(false);
        }
        this.cleanupExecutor();
    }

    public boolean isReconnecting() {
        return this.isReconnecting.get();
    }
}

